<?php
namespace WPUmbrella\Actions\Admin;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Hooks\ExecuteHooksBackend;

class WhiteLabel implements ExecuteHooksBackend
{
    protected $isActiveWhiteLabel = null;

    public function __construct()
    {
        $this->getOwnerService = wp_umbrella_get_service('Owner');
		$this->whiteLabelData = wp_umbrella_get_service('WhiteLabel')->getData();
    }

    public function hooks()
    {
        add_filter('plugin_action_links', [$this, 'pluginLinks'], 10, 2);
        add_filter('all_plugins', [$this, 'pluginInfoFilter'], 10, 2);
        add_filter('plugin_row_meta', [$this, 'pluginRowMeta'], 10, 2);
        add_action('admin_enqueue_scripts', [$this, 'adminEnqueueCSS']);
    }


    public function adminEnqueueCSS($page)
    {
        if ($page !== 'plugins.php' && $page !== 'update-core.php') {
            return;
        }

        if (isset($_GET['plugin_status']) && $_GET['plugin_status'] !== 'mustuse') {
            return;
        }

		if($this->whiteLabelData['plugin_name'] !== 'WP Umbrella' || $this->whiteLabelData['hide_plugin']){
			echo '<style>
			table.plugins [data-plugin="_WPHealthHandlerMU.php"],
			table.plugins [data-plugin="InitUmbrella.php"] {
				display: none;
			}
		  </style>
		  ';
		}


		if($page === 'update-core.php' && ($this->whiteLabelData['hide_plugin'] || $this->whiteLabelData['plugin_name'] !== 'WP Umbrella')) {
			echo '<script>
				document.addEventListener("DOMContentLoaded", function(event) {
					const checkbox = document.querySelector("input[value=\'wp-health/wp-health.php\']")
					console.log({checkbox})
					if(checkbox) {
						checkbox.closest("tr").style.display = "none";
					}
				});

			</script>';
		}
    }

    /**
     * @wp_filter all_plugins
     */
    public function pluginInfoFilter($plugins)
    {

        if (!isset($plugins[WP_UMBRELLA_BNAME])) {
            return $plugins;
        }

        if ($this->whiteLabelData['hide_plugin']) {
            unset($plugins[WP_UMBRELLA_BNAME]);
            return $plugins;
        }

        $plugins[WP_UMBRELLA_BNAME]['Name'] = $this->whiteLabelData['plugin_name'];
        $plugins[WP_UMBRELLA_BNAME]['Title'] = $this->whiteLabelData['plugin_name'];
        $plugins[WP_UMBRELLA_BNAME]['Description'] = $this->whiteLabelData['plugin_description'];
        $plugins[WP_UMBRELLA_BNAME]['AuthorURI'] = $this->whiteLabelData['plugin_author_url'];
        $plugins[WP_UMBRELLA_BNAME]['Author'] = $this->whiteLabelData['plugin_author'];
        $plugins[WP_UMBRELLA_BNAME]['AuthorName'] = $this->whiteLabelData['plugin_author'];
        $plugins[WP_UMBRELLA_BNAME]['PluginURI'] = '';

        return $plugins;
    }

    public function pluginRowMeta($meta, $slug)
    {
        if ($slug !== WP_UMBRELLA_BNAME) {
            return $meta;
        }

        if (isset($meta[2])) {
            unset($meta[2]);
        }

        return $meta;
    }

    public function pluginLinks($links, $file)
    {
        if (WP_UMBRELLA_BNAME !== $file) {
            return $links;
        }

        $settings = sprintf('<a href="%s">%s</a>', admin_url('options-general.php?page=wp-umbrella-settings'), __('Settings'));
        array_unshift($links, $settings);

        return $links;
    }
}
