<?php
namespace WPUmbrella\Controller\Restore;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Models\AbstractController;
use WPUmbrella\Services\Restore\V2\DestroyDirectory;
use ZipArchive;

class DownloadRestorePlugin extends AbstractController
{
    public function executePost($params)
    {
		try {
			$url = isset($params['url']) ? $params['url'] : null;
			$filename = isset($params['filename']) ? $params['filename'] : null;

			if($url === null || $filename === null){
				return $this->returnResponse([
					'success' => false,
					'data' => [
						'code' => 'missing_parameters',
						'message' => 'Invalid parameters'
					]
				], 400);
			}

			$path = sprintf(untrailingslashit(ABSPATH) . '/%s', $filename);

			wp_umbrella_get_service('DownloadZip')->handle($url, $path);

			$zip = new ZipArchive();
			$open = $zip->open($path);

			if($open !== true) {
				return $this->returnResponse([
					'success' => false,
					'data' => [
						'code' => 'invalid_zip',
						'message' => 'Invalid zip file'
					]
				], 400);
			}

			$pathExtract = sprintf(untrailingslashit(ABSPATH) . '/%s', 'umbrella-restore');
			if(!file_exists($pathExtract)){
				mkdir($pathExtract);
			}
			$zip->extractTo($pathExtract);
			$zip->close();

			$response = wp_umbrella_get_service('RestoreWordPressData')->writePluginRestoreData();

			if(!$response['success']){
				return $this->returnResponse([
					'success' => false,
					'data' => [
						'code' => 'error',
						'message' => $response['message']
					]
				], 400);
			}

			if (file_exists($path)) {
				@unlink($path);
			}

			/** @var DestroyDirectory $destroyDirectory */
			$destroyDirectory = wp_umbrella_get_service(DestroyDirectory::class);

			if (file_exists($pathExtract)) {
				$destroyDirectory->handle($pathExtract);
			}

			return $this->returnResponse([
				'success' => true,
				'data' => [
					'path' => $path
				]
			]);
		} catch (\Exception $e) {
			return $this->returnResponse([
				'success' => false,
				'data' => [
					'code' => 'error',
					'message' => $e->getMessage(),
				]
			], 500);
		}
    }
}
