<?php
namespace WPUmbrella\Controller\Theme;

use WPUmbrella\Core\Models\AbstractController;

class Update extends AbstractController
{
    public function executePost($params)
    {
        $theme = isset($params['theme']) ? $params['theme'] : null;

        if (!$theme) {
            return $this->returnResponse(['code' => 'missing_parameters', 'message' => 'No theme'], 400);
        }

        $manageTheme = \wp_umbrella_get_service('ManageTheme');

        try {

			wp_umbrella_get_service('ThemesProvider')->checkDiviTheme();

            $data = $manageTheme->update($theme);

            if (isset($data['status']) && $data['status'] === 'error') {
                return $this->returnResponse($data, 403);
            }

            return $this->returnResponse($data);
        } catch (\Exception $e) {
            \wp_umbrella_get_service('Logger')->error($e->getMessage());

            return $this->returnResponse([
                'code' => 'unknown_error',
                'messsage' => $e->getMessage()
            ]);
        }
    }
}
