<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;

class CleanUpAllData extends RestoreProcessHandler implements CaretakerHandler
{
    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);
        try {
            if (!file_exists(WP_UMBRELLA_DIR_TEMP_RESTORE) || !is_dir(WP_UMBRELLA_DIR_TEMP_RESTORE)) {
                return parent::handle($data);
            }

            if (file_exists(ABSPATH . 'wp-admin/includes/file.php')) {
                require_once ABSPATH . 'wp-admin/includes/file.php';
                WP_Filesystem();
            }


			$databaseZip = sprintf('%s/%s', untrailingslashit(WP_UMBRELLA_DIR_TEMP_RESTORE), 'database.zip');
			$filesZip = sprintf('%s/%s', untrailingslashit(WP_UMBRELLA_DIR_TEMP_RESTORE), 'backup.zip');

            global $wp_filesystem;
			if($wp_filesystem !== null){
				$wp_filesystem->delete(WP_UMBRELLA_DIR_TEMP_RESTORE);
			}

        } catch (\Exception $e) {
            $this->setFailHandler($data, [
                'error_code' => 'clean_up',
                'error_message' => $e->getMessage()
            ]);
            return false;
        }

        $data['originator'] = $originator;

        return parent::handle($data);
    }
}
