<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;
use WPUmbrella\Core\Restore\Memento\RestoreOriginator;

class DiskSpaceHandler extends RestoreProcessHandler implements CaretakerHandler
{
    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);

        $value = null;
        if (!function_exists('disk_free_space')) {
            $value = 'partial';
        } else {
            $value = @disk_free_space(ABSPATH);
            if (!$value) {
                $value = 'partial';
            }
        }

        $originator->setValueInState('disk_free_space', $value);

        $zipFile = $originator->getValueInState('zip_size_bytes_file');
        if ($zipFile !== null && $value !== 'partial' && $value < $zipFile) {
            $this->setFailHandler($data, [
                'error_code' => 'disk_space_for_file',
                'error_message' => 'Insufficient disk space',
            ]);

            return false;
        }

        $zipDatabase = $originator->getValueInState('zip_size_bytes_database');
        if ($zipDatabase !== null && $value !== 'partial' && $value < $zipDatabase) {
            $this->setFailHandler($data, [
                'error_code' => 'disk_space_for_database',
                'error_message' => 'Insufficient disk space',
            ]);

            return false;
        }

        $data['originator'] = $originator;

        return parent::handle($data);
    }
}
