<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;
use Coderatio\SimpleBackup\SimpleBackup;
use ZipArchive;
use WP_Error;

class ExtractDatabaseHandler extends RestoreProcessHandler implements CaretakerHandler
{
    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);

        $path = $originator->getValueInState('zip_database_path');

        if ($path === null || !file_exists($path)) {
            $this->setFailHandler($data, [
                'error_code' => 'extract_database_handler',
            ]);
            return false;
        }

        if (\file_exists(ABSPATH . 'wp-admin/includes/file.php')) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
            WP_Filesystem();
        }

        global $wp_filysystem;

        try {

			$zip = new ZipArchive();
			$open = $zip->open($path);
			if($open !== true) {
				$this->setFailHandler($data, [
					'error_code' => 'restore_extract_database_handler_open',
					'error_message' => 'Failed to open zip database',
				]);
				return false;
			}

			$originator->setValueInState('total_tables', $zip->numFiles);

			$iterator = $originator->getValueInState('batch_database_iterator');
			if(!$iterator){
				$iterator = 0;
			}

			$stat = $zip->statIndex($iterator);
			if(!$stat){
				$this->setFailHandler($data, [
					'error_code' => 'restore_extract_database_index_not_exist',
				]);
				return false;
			}

			$file = $stat['name'];

			$zip->extractTo(WP_UMBRELLA_DIR_TEMP_RESTORE, $file);

			$iterator++;
			$originator->setValueInState('batch_database_iterator', $iterator);
			$originator->setValueInState('batch_database_file', sprintf('%s/%s', untrailingslashit(WP_UMBRELLA_DIR_TEMP_RESTORE), $file));

			$zip->close();
        } catch (\Exception $e) {
            $this->setFailHandler($data, [
                'error_code' => 'extract_database_handler',
                'error_message' => $e->getMessage()
            ]);
            return false;
        }

		wp_umbrella_get_service('RestoreRunner')->scheduledRestoreDatabase();

        $data['originator'] = $originator;

        return parent::handle($data);
    }
}
