<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;
use Coderatio\SimpleBackup\SimpleBackup;
use ZipArchive;
use WP_Error;

class RestoreDatabaseHandler extends RestoreProcessHandler implements CaretakerHandler
{
    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);

        try {
            $file = $originator->getValueInState('batch_database_file');

            if (!$file) {
                $this->setFailHandler($data, [
                    'error_code' => 'restore_database_handler',
                    'error_message' => 'No file extract'
                ]);
                return false;
            }

            $logfile = $this->getLogfile($originator->getState());

            wp_umbrella_get_service('LogProcess')->log(
                sprintf('Restore file database: %s', $file),
                [
                    'logfile' => $logfile,
                ]
            );

            if (!file_exists($file)) {
                $this->setFailHandler($data, [
                    'error_code' => 'restore_database_handler',
                    'error_message' => 'Table file not found'
                ]);
                return false;
            }

            $simpleBackup = SimpleBackup::setDatabase([
                DB_NAME,
                DB_USER,
                DB_PASSWORD,
                DB_HOST,
            ])->importFrom($file);

			wp_umbrella_remove_file($file);

			$runner = wp_umbrella_get_service('RestoreRunner');

			$totalTables = $originator->getValueInState('total_tables');
			$iterator = $originator->getValueInState('batch_database_iterator');

            if ($iterator+1 < $totalTables) {
				// Schedule other restore table
                $runner->scheduledRestorePrepareDatabase();
            }
			else{
				// Finish restoration
				$restorationId = $originator->getValueInState('restoration_id');
				wp_umbrella_get_service('RestorationApi')->postFinishRestoreDatabase($restorationId);
				$runner->cleanup();

				$runner->scheduledRestoreFinish();
			}


        } catch (\Exception $e) {
            $this->setFailHandler($data, [
                'error_code' => 'restore_database_handler',
                'error_message' => $e->getMessage()
            ]);
            return false;
        }

        $data['originator'] = $originator;

        return parent::handle($data);
    }
}
