<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;
use ZipArchive;


class RestoreFilesHandler extends RestoreProcessHandler implements CaretakerHandler
{
	const MAX_SIZE = 1048576 * 200; // default 150MB

    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);

        $parts = $originator->getValueInState('zip_files_parts');

        if ($parts === null || empty($parts)) {
            $this->setFailHandler($data, [
                'error_code' => 'restore_files_handler',
            ]);
            return false;
        }

        $path = $originator->getValueInState('zip_files_path');

        if ($path === null || !file_exists($path)) {
            $this->setFailHandler($data, [
                'error_code' => 'resprepare_tore_files_handler',
            ]);
            return false;
        }


        try {
            wp_umbrella_get_service('LogProcess')->log('Execute unzip archive files', [
                'logfile' => $this->getLogfile($originator->getState()),
            ]);

			@set_time_limit(0);

			$zip = new ZipArchive();
			$open = $zip->open($path);
			if($open !== true) {
				$this->setFailHandler($data, [
					'error_code' => 'restore_files_handler_open',
					'error_message' => 'Failed to open zip file',
				]);
				return false;
			}

			$iterator = $originator->getValueInState('iterator_zip_parts');
			if(!$iterator) {
				$iterator = 0;
			}

			wp_umbrella_get_service('MaintenanceMode')->toggleMaintenanceMode(true);
			if(isset($parts[$iterator]) && file_exists($parts[$iterator])) {
				$content = json_decode(file_get_contents($parts[$iterator]), true);
				$zip->extractTo(ABSPATH, $content);
				wp_umbrella_remove_file($parts[$iterator]);
			} else {
				wp_umbrella_get_service('MaintenanceMode')->toggleMaintenanceMode(false);
				$this->setFailHandler($data, [
					'error_code' => 'restore_files_part_not_found',
				]);
				return false;
			}

			wp_umbrella_get_service('MaintenanceMode')->toggleMaintenanceMode(false);

			$iterator++;
			$originator->setValueInState('iterator_zip_parts', $iterator);

			$zip->close();

        } catch (\Exception $e) {
            $this->setFailHandler($data, [
                'error_code' => 'restore_files_exception_handler',
                'error_message' => $e->getMessage()
            ]);
            return false;
        }

		if($iterator + 1 < count($parts)){
			wp_umbrella_get_service('RestoreRunner')->scheduledRestoreFiles();
		}
		else{
			$restorationId = $originator->getValueInState('restoration_id');
			wp_umbrella_get_service('RestorationApi')->postFinishRestoreFiles($restorationId);
		}

        $data['originator'] = $originator;

        return parent::handle($data);
    }
}
