<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;

class SetupShutdown extends RestoreProcessHandler implements CaretakerHandler
{
    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);
        $logfile = $this->getLogfile($originator->getState());

        add_action('shutdown', function () use ($logfile) {
            $lastError = error_get_last();
            if ($lastError === null) {
                return;
            }

            wp_umbrella_get_service('LogProcess')->log(
                \sprintf('File: %s', $lastError['file']),
                [
                    'logfile' => $logfile,
                ]
            );
            wp_umbrella_get_service('LogProcess')->log(
                \sprintf('Message: %s', $lastError['message']),
                [
                    'logfile' => $logfile,
                ]
            );

            header('Cache-Control: no-cache');
            header('Content-Type: application/json');
            http_response_code(500);
            echo json_encode([
                'error_code' => 'restore_shutdown',
                'error_message' => $lastError['message'],
            ]);
            exit;
        });


        return parent::handle($data);
    }
}
