<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;
use WPUmbrella\Core\Restore\Memento\RestoreOriginator;

class WordPressDataSqlHandler extends RestoreProcessHandler implements CaretakerHandler
{
    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);

        $value = [
            'user' => null,
            'password' => null,
            'host' => null,
            'prefix' => null,
        ];
        try {
            $upload_dir = wp_upload_dir();
            global $wpdb;

            $value = [
                'dbname' => DB_NAME,
                'user' => DB_USER,
                'password' => DB_PASSWORD,
                'charset' => DB_CHARSET,
                'host' => DB_HOST,
                'collate' => DB_COLLATE,
                'prefix' => $wpdb->prefix,
            ];

            $file = 'config.php';
            $current = "<?php

if(!defined('DB_NAME')) {
	define('DB_NAME', '{$value['dbname']}');
}

if(!defined('DB_USER')) {
	define('DB_USER', '{$value['user']}');
}

if(!defined('DB_PASSWORD')) {
	define('DB_PASSWORD', '{$value['password']}');
}

if(!defined('DB_CHARSET')) {
	define('DB_CHARSET', '{$value['charset']}');
}

if(!defined('DB_COLLATE')) {
	define('DB_COLLATE', '{$value['collate']}');
}

if(!defined('DB_HOST')) {
	define('DB_HOST', '{$value['host']}');
}

if(!defined('DB_PREFIX')) {
	define('DB_PREFIX', '{$value['prefix']}');
}
			";
            file_put_contents(sprintf('%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, $file), $current);
        } catch (\Exception $e) {
            $this->setFailHandler($data, [
                'error_code' => 'wordpress_data_sql',
                'error_message' => $e->getMessage(),
            ]);

            return false;
        }

        $data['originator'] = $originator;

        return parent::handle($data);
    }
}
