<?php
namespace WPUmbrella\Core\Restore\Observers;

if (!defined('ABSPATH')) {
    exit;
}

class LogStateObserver implements \SplObserver
{
    protected function getLogfile($state)
    {
        $logfile = null;
        if (!isset($state['logfile'])) {
            $logfile = sprintf('%s/%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, 'logs', 'umbrella-restore-' . \substr(md5(time()), 0, 6) . '.json');
        } else {
            $logfile = $state['logfile'];
        }

        return $logfile;
    }

    public function update(\SplSubject $subject)
    {
        $data = $subject->getData();
        if (empty($data['originator'])) {
            return;
        }

        $originator = $data['originator'];

        $logfile = $originator->getValueInState('logfile');
        if (empty($logfile)) {
            $logfile = $this->getLogfile($originator->getState());
            $originator->setValueInState('logfile', basename($logfile));
        } else {
            $logfile = sprintf('%s/%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, 'logs', $logfile);
        }

        $logProcess = wp_umbrella_get_service('LogProcess');
        $logProcess->log($originator->getValueInState('handler'), [
            'logfile' => $logfile,
        ]);

        if ($originator->getValueInState('error_code') !== null) {
            $logProcess->log('Error Code : %s', $originator->getValueInState('error_code'));
        }
        if ($originator->getValueInState('error_message') !== null) {
            $logProcess->log('Error Message : %s', $originator->getValueInState('error_message'));
        }

		$restorationId = $originator->getValueInState('restoration_id');

		wp_umbrella_get_service('RestorationApi')->postLog($restorationId, [
			"config" => $originator->getState(),
			"logs" => wp_umbrella_get_service('LogProcess')->getContent($logfile),
		]);

    }
}
