<?php
namespace WPUmbrella\Core\Restore\Observers;

if (!defined('ABSPATH')) {
    exit;
}
use WPUmbrella\Core\Restore\Memento\RestoreCaretaker;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;

class MementoObserver implements \SplObserver
{
    public function update(\SplSubject $subject)
    {
        if (($subject instanceof CaretakerHandler) === false) {
            return;
        }

        $data = $subject->getData();

        if (empty($data['originator'])) {
            return;
        }

        $data['caretaker']->setOriginator($data['originator']);
        $data['caretaker']->backup();

		if(!file_exists(WP_UMBRELLA_DIR_TEMP_RESTORE)){
			return;
		}

        $file = 'config.json';
        $path = sprintf('%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, $file);
		$current = json_encode($data['originator']->getState());
		file_put_contents($path, $current);
    }
}
