<?php
namespace WPUmbrella\Core\Restore\Observers;


use WPUmbrella\Core\Restore\Memento\RestoreCaretaker;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;

class RestoreOnErrorObserver implements \SplObserver
{
    public function update(\SplSubject $subject)
    {
        if (($subject instanceof CaretakerHandler) === false) {
            return;
        }

        $data = $subject->getData();
        if (empty($data['originator'])) {
            return;
        }

        $originator = $data['originator'];

        if ($originator->getValueInState('error_code') === null) {
            return;
        }

		$restorationId = $originator->getValueInState('restoration_id');

		wp_umbrella_get_service('RestorationApi')->postOnError($restorationId , [
			'error_code' => $originator->getValueInState('error_code'),
			'error_message' => $originator->getValueInState('error_message'),
		]);
    }
}
