<?php
namespace WPUmbrella\Services\Backup\QueueRunner\V2;

use WPUmbrella\Core\Backup\Builder\V2\BackupBuilder;
use WPUmbrella\Services\Backup\V2\BackupDirector;

class BackupQueuePrepareDatabaseBatch extends AbstractBackupQueue
{

	protected function callWithWordPress($data){
		try {
			@set_time_limit(0);

			$projectId = wp_umbrella_get_project_id();
			$token = wp_umbrella_get_api_key();
			$secretToken = wp_umbrella_get_secret_token();

            $response = wp_remote_post(site_url(), [
                'headers' => [
					'X-Project' => $projectId,
					'X-Umbrella' => $token,
					'X-Secret-Token' => $secretToken,
					'X-Action' => '/v1/backups/prepare-batch-database'
				],
                'body' => json_encode([
					'table' => $data->getTableByCurrentBatch()['name']
				]),
                'timeout' => 0,
            ]);

            $batchs = json_decode(wp_remote_retrieve_body($response), true);

            return [
				'success' => true,
				'data' => $batchs
			];

		} catch (\Exception $e) {
			return [
				'success' => false,
				'data' => []
			];
		}
	}

    public function run($options = [])
    {

		$version = $options['version'] ?? 'v1';
		$manageProcess = $this->getManageProcessByVersion($version);

		$data = $manageProcess->getBackupData();

		try {
			$table = $data->getTableByCurrentBatch()['name'];

			$batchs = wp_umbrella_get_service('BackupDatabaseConfigurationV2')->getBatchForTable($data->getTableByName($table));

			$data->setTableBatchsByName($table, $batchs);
			$manageProcess->updateBackupData($data->getData());

			return [
				'success' => true,
			];
		} catch (\Exception $e) {
			return [
				'success' => false,
			];
		}


    }
}
