<?php
namespace WPUmbrella\Services\Provider;

if (!defined('ABSPATH')) {
    exit;
}

use Morphism\Morphism;

class Themes
{
    const NAME_SERVICE = 'ThemesProvider';

	protected function setThemeDirectories(){
		global $wp_theme_directories;

        // When the plugin is MU-loaded, the WordPress theme directories are not set.
        if (empty($wp_theme_directories)) {
            // Register the default theme directory root.
            register_theme_directory(get_theme_root());
        }

	}

	public function checkDiviTheme(){
		if(!defined('ET_CORE_URL') || !defined('ET_CORE_VERSION')){
			return;
		}

		$transientDivi = get_site_transient('et_update_themes');

		$transient = get_site_transient('update_themes');

		$etCoreUpdate = new \ET_Core_Updates(ET_CORE_URL, ET_CORE_VERSION);
		$lastChecked = $etCoreUpdate->check_themes_updates($transient);

		if(!empty($lastChecked->response) && isset($lastChecked->response['Divi'])){
			if($lastChecked->response['Divi']['new_version'] !== $lastChecked->checked['Divi']){
				$themes["Divi"]['latest_version'] = $lastChecked->response['Divi']['new_version'];

				// Update the transient with Divi transient
				$transient->checked['Divi'] = $lastChecked->response['Divi']['new_version'];
				$transient->response['Divi'] = $transientDivi->response['Divi'];
				set_site_transient('update_themes', $transient);
			}
		}

		return $lastChecked;

	}

    public function getThemes()
    {
        require_once ABSPATH . '/wp-admin/includes/theme.php';

		$this->setThemeDirectories();

		if(defined('ET_CORE_URL') && defined('ET_CORE_VERSION')){
			$lastChecked = $this->checkDiviTheme();

		}
        $themes = wp_get_themes();


		if(defined('ET_CORE_URL') && defined('ET_CORE_VERSION')){ // Divi theme
			if(!empty($lastChecked->response) && isset($lastChecked->response['Divi'])){
				if($lastChecked->response['Divi']['new_version'] !== $lastChecked->checked['Divi']){
					$themes["Divi"]['latest_version'] = $lastChecked->response['Divi']['new_version'];
				}
			}
		}

        $active = get_option('current_theme');

        if (function_exists('get_site_transient') && $transient = get_site_transient('update_themes')) {
            $current = $transient;
        } elseif ($transient = get_transient('update_themes')) {
            $current = $transient;
        } else {
            $current = get_option('update_themes');
        }

		$siteTransient = get_site_transient('update_themes');

        foreach ((array) $themes as $key => $theme) {
            $new_version = isset($current->response[$theme->get_stylesheet()]) ? $current->response[$theme->get_stylesheet()]['new_version'] : null;

            $theme_array = [
                'name' => $theme->get('Name'),
                'active' => $active == $theme->get('Name'),
                'template' => $theme->get_template(),
                'stylesheet' => $theme->get_stylesheet(), // "stylesheet", for some reason. This is the theme identifier; ie. "twentytwelve".
                'screenshot' => $theme->get_screenshot(),
                'author_uri' => $theme->get('AuthorURI'),
                'author' => $theme->get('Author'),
                'latest_version' => $new_version ? $new_version : $theme->get('Version'),
                'version' => $theme->get('Version'),
                'theme_uri' => $theme->get('ThemeURI'),
                'require_wp' => $theme->get('RequiresWP'),
				'package' => isset($siteTransient->response[$theme->get_stylesheet()]) ? $siteTransient->response[$theme->get_stylesheet()]['package'] : null,
                'requires_php' => $theme->get('RequiresPHP'),
            ];

            $themes[$key] = $theme_array;
        }

        return array_values($themes);
    }

    public function getCurrentTheme()
    {
        require_once ABSPATH . '/wp-admin/includes/theme.php';

		$this->setThemeDirectories();

        $theme = wp_get_theme();

        if ($theme instanceof \WP_Theme) {
            return  [
                'name' => $theme->get('Name'),
                'active' => true,
                'template' => $theme->get_template(),
                'stylesheet' => $theme->get_stylesheet(),
                'screenshot' => $theme->get_screenshot(),
                'author_uri' => $theme->get('AuthorURI'),
                'author' => $theme->get('Author'),
                'version' => $theme->get('Version'),
                'theme_uri' => $theme->get('ThemeURI'),
                'require_wp' => $theme->get('RequiresWP'),
                'requires_php' => $theme->get('RequiresPHP'),
            ];
        }

        return get_option('current_theme');
    }
}
