<?php
namespace WPUmbrella\Services\Restore\QueueRunner;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\Builder\RestoreBuilder;

class RestoreQueueRunnerFiles
{

	public function run()
    {
        $director = wp_umbrella_get_service('RestoreDirector');

        $builder = new RestoreBuilder();
        $director->setBuilder($builder);

		$director->buildRestoreFilesHandlers();
        $kernel = $builder->getKernel();

        $originator = wp_umbrella_get_service('RestoreConfiguration')->getOriginatorFromFile();

        $kernel->execute($originator);

    }

}
