<?php
namespace WPUmbrella\Services\Restore;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\Memento\RestoreOriginator;

class RestoreConfiguration
{
    public function getOriginatorFromFile()
    {
        $originator = new RestoreOriginator();

        try {
            $file = 'config.json';
            $path = sprintf('%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, $file);
            if (file_exists($path)) {
                $config = json_decode(file_get_contents($path), true);
                $originator->setState($config);
            }
        } catch (\Exception $e) {
            return false;
        }


		return $originator;
    }
}


