<?php
namespace WPUmbrella\Services\Restore;

use ActionScheduler;
use ActionScheduler_Store;

if (!defined('ABSPATH')) {
    exit;
}

class RestoreRunner
{
    const GROUP = 'wp-umbrella';

    const ACTION_RESTORE_DATABASE = 'wp_umbrella_restore_database_batch';
    const ACTION_RESTORE_FILES = 'wp_umbrella_restore_files_batch';
    const ACTION_RESTORE_PREPARE_FILES = 'wp_umbrella_restore_prepare_files_batch';
    const ACTION_RESTORE_PREPARE_DATABASE = 'wp_umbrella_restore_prepare_database_batch';
    const ACTION_RESTORE_FINISH = 'wp_umbrella_restore_finish';

	const ACTION_DOWNLOAD_ZIP = 'wp_umbrella_download_zip_batch';

    public function hasScheduledBatchInProcess(): bool
    {
        if (function_exists('as_has_scheduled_action')) {
            return \as_has_scheduled_action(self::ACTION_RESTORE_DATABASE, [], self::GROUP);
        } elseif (function_exists('as_next_scheduled_action')) {
            return \as_next_scheduled_action(self::ACTION_RESTORE_DATABASE, [], self::GROUP);
        }

        return false;
    }

    public function hasRunningBatchInProcess(): bool
    {
        return $this->hasRunningHookInProcess(self::ACTION_RESTORE_DATABASE) || $this->hasRunningHookInProcess(self::ACTION_RESTORE_FILES) || $this->hasRunningHookInProcess(self::ACTION_DOWNLOAD_ZIP);
    }

    public function hasRunningHookInProcess($hook, $args = []): bool
    {
        if (!ActionScheduler::is_initialized(__FUNCTION__)) {
            return false;
        }

        $query_args = [
            'hook' => $hook,
            'status' => [ActionScheduler_Store::STATUS_RUNNING],
            'group' => self::GROUP,
            'orderby' => 'none',
        ];

        if (null !== $args) {
            $query_args['args'] = $args;
        }

        $store = ActionScheduler::store();
        if (!method_exists($store, 'query_action')) {
            $store = wp_umbrella_get_service('StoreRetrocompatibility');
        }

		$action_id = $store->query_action($query_args);

        return $action_id !== null;
    }

    public function scheduledRestoreDatabase()
    {
        as_schedule_single_action(time() + 1, self::ACTION_RESTORE_DATABASE, [], self::GROUP);
    }

    public function scheduledRestorePrepareDatabase()
    {
        as_schedule_single_action(time() + 1, self::ACTION_RESTORE_PREPARE_DATABASE, [], self::GROUP);
    }

    public function scheduledRestorePrepareFiles()
    {
        as_schedule_single_action(time() + 1, self::ACTION_RESTORE_PREPARE_FILES, [], self::GROUP);
    }

    public function scheduledRestoreFiles()
    {
        as_schedule_single_action(time() + 1, self::ACTION_RESTORE_FILES, [], self::GROUP);
    }

	public function scheduledDownloadZip(){
		as_schedule_single_action(time() + 1, self::ACTION_DOWNLOAD_ZIP, [], self::GROUP);
	}

	public function scheduledRestoreFinish(){
		as_schedule_single_action(time() + 1, self::ACTION_RESTORE_FINISH, [], self::GROUP);
	}

    public function unscheduledBatch()
    {
        as_unschedule_action(self::ACTION_RESTORE_DATABASE, [], self::GROUP);
        as_unschedule_action(self::ACTION_RESTORE_FILES, [], self::GROUP);
        as_unschedule_action(self::ACTION_RESTORE_PREPARE_DATABASE, [], self::GROUP);
        as_unschedule_action(self::ACTION_RESTORE_PREPARE_FILES, [], self::GROUP);
        as_unschedule_action(self::ACTION_DOWNLOAD_ZIP, [], self::GROUP);
        as_unschedule_action(self::ACTION_RESTORE_FINISH, [], self::GROUP);
		$this->cleanup();
    }

	public function restoreInProgress(){
		$path = sprintf('%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, 'config.json');
		return  file_exists($path);
	}

	public function cleanup()
    {
        try {

            if (file_exists(ABSPATH . 'wp-admin/includes/file.php')) {
                require_once ABSPATH . 'wp-admin/includes/file.php';
                WP_Filesystem();
            }


            global $wp_filesystem;
			if($wp_filesystem !== null){
				if($wp_filesystem->exists(WP_UMBRELLA_DIR_TEMP_RESTORE)){
					$wp_filesystem->delete(WP_UMBRELLA_DIR_TEMP_RESTORE, true);
				}


				$wp_filesystem->delete(sprintf(untrailingslashit(ABSPATH) . '/umbrella-restore'), true);
				$wp_filesystem->delete(sprintf(untrailingslashit(ABSPATH) . '/umbrella-restore.php'), true);
				$wp_filesystem->delete(sprintf(untrailingslashit(ABSPATH) . '/umbrella-restore.zip'), true);

			}

        } catch (\Exception $e) {

            return false;
        }

        return true;
    }
}
