<?php

namespace WPUmbrella\Services\Restore\V2;

use Coderatio\SimpleBackup\SimpleBackup;
use Exception;

class RestoreDatabase
{
	public function handle(string $filename): array
	{

		if ( ! file_exists($filename)) {
			return [
				// Success true because no need to prevent this.
				'success' => true,
				'data'    => [],
			];
		}

		try {
			ob_start();
			$simpleBackup = SimpleBackup::setDatabase([
				DB_NAME,
				DB_USER,
				DB_PASSWORD,
				DB_HOST,
			])->importFrom($filename);

			$output = ob_get_clean();
			if ( ! empty($output)) {
				return [
					'success' => false,
					'data'    => [
						'code'    => 'restore_failed_database',
						'message' => $output,
					],
				];
			}

			if (file_exists($filename)) {
				@unlink($filename);
			}

			return [
				'success' => true,
				'data'    => [
					'message' => sprintf('Table %s restored', basename($filename)),
					'output' => $output
				],
			];
		} catch (Exception $e) {
			return [
				'success' => false,
				'data'    => [
					'code'    => 'restore_failed_database',
					'message' => $e->getMessage(),
				],
			];
		}
	}

}
