<?php
/**
 * @var $args
 */
?>
<label for="<?php echo esc_attr( $args['name'] ); ?>"><?php echo esc_html( $args['label'] ); ?></label>
<input type="text" id="<?php echo esc_attr( $args['name'] ); ?>"
	name="<?php echo esc_attr( $args['name'] ); ?>" size="50"
	class="<?php echo esc_attr( $args['class'] ?? '' ); ?>"
	value="<?php echo esc_attr( $args['value'] ); ?>"/>

<?php if ( ! empty( $args['description'] ) ) { ?>
	<span class="field-description"><?php echo wp_kses_post( $args['description'] ); ?></span>
	<?php
}
