<xsl:stylesheet version="1.1" xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
                xmlns:news="http://www.google.com/schemas/sitemap-news/0.9"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
    <xsl:template match="/">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <title>Google News Sitemap</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
                <style type="text/css">
                    body { font-family: 'Lucida Grande', 'Lucida Sans Unicode', Tahoma, Verdana, Arial, sans-serif; font-size: 12px; }
                    a { text-decoration: none; color: #4a4adc; }
                    table { margin-bottom: 20px; font-size: 12px; }
                    table tr:nth-child(odd) { background-color: #F5F5F5; }
                    table tr th { min-width: 80px; padding: 5px 7px; text-align: left; }
                    table tr th:first-child { min-width: 15px; }
                    table tr th:nth-child(2) { min-width: 120px; }
                    table tr td { padding: 5px 7px; }
                    table tr td a { color: #4a4adc;}
                    .header { padding: 0; margin: 10px 0 20px; }
                </style>
            </head>
            <body>
                <h1>Google News Sitemap</h1>
                <div class="header">
                    <p>
                        <a href="https://support.google.com/news/publisher/answer/75717" target="_blank">Google News Sitemap</a> is generated by
                        <a href="https://wordpress.org/plugins/xml-sitemap-generator-for-google/">Google XML Sitemaps Generator Plugin</a>
                    </p>
                    <p>Note that <strong>only posts from the last 48 hours</strong> will be processed by <a href="https://news.google.com" target="_blank">Google News</a>.</p>
                </div>
                <table cellspacing="0">
                    <tr>
                        <th>#</th>
                        <th>Title</th>
                        <th>Language</th>
                        <th>Keywords</th>
                        <th>Stocks</th>
                        <th>Publication Date</th>
                    </tr>
                    <xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
                    <xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
                    <xsl:for-each select="./sitemap:urlset/sitemap:url">
                        <tr>
                            <xsl:if test="position() mod 2 != 1">
                                <xsl:attribute name="class">high</xsl:attribute>
                            </xsl:if>
                            <td>
                                <xsl:value-of select="position()"/>
                            </td>
                            <td>
                                <xsl:variable name="url">
                                    <xsl:value-of select="sitemap:loc"/>
                                </xsl:variable>
                                <a href="{$url}">
                                    <xsl:value-of select="news:news/news:title"/>
                                </a>
                            </td>
                            <td>
                                <xsl:value-of select="news:news/news:publication/news:language"/>
                            </td>
                            <td>
                                <xsl:value-of select="news:news/news:keywords"/>
                            </td>
                            <td>
                                <xsl:value-of select="news:news/news:stock_tickers"/>
                            </td>
                            <td>
                                <xsl:value-of select="concat(substring(news:news/news:publication_date,0,11),concat(' ', substring(news:news/news:publication_date,12,8)))"/>
                                (<xsl:value-of select="substring(news:news/news:publication_date,20,6)"/>)
                            </td>
                        </tr>
                    </xsl:for-each>
                </table>
                <div class="footer">Generated by <a href="https://wpgrim.net/">WP Grim</a> -
                    <a href="https://wordpress.org/plugins/xml-sitemap-generator-for-google/">Google XML Sitemaps Generator Plugin</a>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
