<?php
/**
 * Dynamic events file.
 *
 * Events are defined in this file.
 *
 * @package mwp-al-ext
 * @since   2.0.0
 *
 * @phpcs   :disable WordPress.WP.I18n.MissingTranslatorsComment
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// If not included correctly, then return.
if ( ! class_exists( '\WSAL\MainWPExtension\Activity_Log' ) ) {
	exit();
}

/**
 * Define Dynamic Alerts.
 *
 * Defines dynamic alerts for the plugin.
 */
function mwpal_dynamic_events_init() {
	$activity_log = \WSAL\MainWPExtension\mwpal_extension();
	$activity_log->alerts->RegisterGroup(
		array(
			'Users Logins & Sessions Events' => array(
				'User Activity' => array(
					array(
						1000,
						WSAL_LOW,
						'User logged in',
						'User logged in.',
						'user',
						'login',
					),
					array(
						1001,
						WSAL_LOW,
						'User logged out',
						'User logged out.',
						'user',
						'logout',
					),
					array(
						1002,
						WSAL_MEDIUM,
						'Login failed',
						'%Attempts% failed login(s).',
						'user',
						'failed-login',
					),
					array(
						1003,
						WSAL_LOW,
						'Login failed  / non existing user',
						'%Attempts% failed login(s). %LineBreak% %LogFileText%',
						'system',
						'failed-login',
					),
					array(
						1004,
						WSAL_MEDIUM,
						'Login blocked',
						'Login blocked because other session(s) already exist for this user. %LineBreak% IP address: %ClientIP%',
						'user',
						'blocked',
					),
					array(
						1005,
						WSAL_LOW,
						'User logged in with existing session(s)',
						'User logged in however there are other session(s) already for this user. %LineBreak% IP address(es): %IPAddress%',
						'user',
						'login',
					),
					array(
						1006,
						WSAL_MEDIUM,
						'User logged out all other sessions with the same username',
						'Logged out all other sessions with the same user.',
						'user',
						'logout',
					),
					array(
						1007,
						WSAL_MEDIUM,
						'User session destroyed and logged out',
						'Terminated the session of the user %TargetUserName%. %LineBreak% Role: %TargetUserRole% %LineBreak% Session ID: %TargetSessionID%',
						'user',
						'logout',
					),
					array(
						1008,
						WSAL_MEDIUM,
						'Switched to another user',
						'Switched the session to being logged in as %TargetUserName%. %LineBreak% Role: %TargetUserRole%',
						'user',
						'login',
					),
					array(
						1009,
						WSAL_LOW,
						'The plugin terminated an idle session for a user',
						'The plugin terminated an idle session for the user %username%. %LineBreak% Role: %TargetUserRole% %LineBreak% Session ID: %SessionID%',
						'user',
						'logout',
					),
					array(
						2010,
						WSAL_MEDIUM,
						'User uploaded file to the Uploads directory',
						'Uploaded a file called %FileName%. %LineBreak% Directory: %FilePath% %LineBreak% View attachment page: %AttachmentUrl%',
						'file',
						'uploaded',
					),
					array(
						2011,
						WSAL_LOW,
						'User deleted file from Uploads directory',
						'Deleted the file %FileName%. %LineBreak% Directory: %FilePath%',
						'file',
						'deleted',
					),
					array(
						1010,
						WSAL_INFORMATIONAL,
						'User requested a password reset',
						'User requested a password reset. This does not mean that the password was changed.',
						'user',
						'submitted',
					),
				),
			),
			'Content & Comments'             => array(
				'Content'             => array(
					array(
						2000,
						WSAL_INFORMATIONAL,
						'User created a new post and saved it as draft',
						'Created the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'created',
					),
					array(
						2001,
						WSAL_LOW,
						'User published a post',
						'Published the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'published',
					),
					array(
						2002,
						WSAL_LOW,
						'User modified a post',
						'Modified the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2008,
						WSAL_MEDIUM,
						'User permanently deleted a post from the trash',
						'Permanently deleted the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus%',
						'post',
						'deleted',
					),
					array(
						2012,
						WSAL_MEDIUM,
						'User moved a post to the trash',
						'Moved the post %PostTitle% to trash. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'deleted',
					),
					array(
						2014,
						WSAL_LOW,
						'User restored a post from trash',
						'Restored the post %PostTitle% from trash. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'restored',
					),
					array(
						2017,
						WSAL_INFORMATIONAL,
						'User changed post URL',
						'Changed the URL of the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous URL: %OldUrl% %LineBreak% New URL: %NewUrl% %LineBreak% View the post in editor: %EditorLinkPost%',
						'post',
						'modified',
					),
					array(
						2019,
						WSAL_INFORMATIONAL,
						'User changed post author',
						'Changed the author of the post %PostTitle% to %NewAuthor%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous author: %OldAuthor% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2021,
						WSAL_MEDIUM,
						'User changed post status',
						'Changed the status of the post %PostTitle% to %NewStatus%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Previous status: %OldStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2025,
						WSAL_LOW,
						'User changed the visibility of a post',
						'Changed the visibility of the post %PostTitle% to %NewVisibility%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous visibility status: %OldVisibility% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2027,
						WSAL_INFORMATIONAL,
						'User changed the date of a post',
						'Changed the date of the post %PostTitle% to %NewDate%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous date: %OldDate% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2047,
						WSAL_LOW,
						'User changed the parent of a page',
						'Changed the parent of the post %PostTitle% to %NewParentName%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous parent: %OldParentName% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2048,
						WSAL_LOW,
						'User changed the template of a page',
						'Changed the template of the post %PostTitle% to %NewTemplate%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous template: %OldTemplate% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2049,
						WSAL_INFORMATIONAL,
						'User set a post as sticky',
						'Set the post %PostTitle% as sticky. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2050,
						WSAL_INFORMATIONAL,
						'User removed post from sticky',
						'Removed the post %PostTitle% from sticky. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2065,
						WSAL_LOW,
						'User modified the content of a post',
						'Modified the content of the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the content changes: %RevisionLink% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2073,
						WSAL_INFORMATIONAL,
						'User submitted a post for review',
						'Submitted the post %PostTitle% for review. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2074,
						WSAL_LOW,
						'User scheduled a post',
						'Scheduled the post %PostTitle% to be published on %PublishingDate%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2086,
						WSAL_INFORMATIONAL,
						'User changed title of a post',
						'Changed the title of the post %OldTitle% to %NewTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2100,
						WSAL_INFORMATIONAL,
						'User opened a post in the editor',
						'Opened the post %PostTitle% in the editor. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'opened',
					),
					array(
						2101,
						WSAL_INFORMATIONAL,
						'User viewed a post',
						'Viewed the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% URL: %PostUrl% %LineBreak% View the post in editor: %EditorLinkPost%',
						'post',
						'viewed',
					),
					array(
						2111,
						WSAL_LOW,
						'User enabled/disabled comments in a post',
						'Comments in the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'enabled',
					),
					array(
						2112,
						WSAL_LOW,
						'User enabled/disabled trackbacks and pingbacks in a post',
						'Pingbacks and Trackbacks in the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'enabled',
					),
					array(
						2129,
						WSAL_INFORMATIONAL,
						'User updated the excerpt in a post',
						'The excerpt of the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous excerpt entry: %old_post_excerpt% %LineBreak% New excerpt entry: %post_excerpt% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2130,
						WSAL_INFORMATIONAL,
						'User updated the featured image in a post',
						'The featured image of the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous image: %previous_image% %LineBreak% New image: %new_image% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
				),
				'Tags'                => array(
					array(
						2119,
						WSAL_INFORMATIONAL,
						'User added post tag',
						'Added tag(s) to the post %PostTitle%. %LineBreak% ID: %PostID% %LineBreak% Type: %PostType% %LineBreak% Status: %PostStatus% %LineBreak% Added tag(s): %tag% %LineBreak% View the post in editor: %EditorLinkPost%',
						'post',
						'modified',
					),
					array(
						2120,
						WSAL_INFORMATIONAL,
						'User removed post tag',
						'Removed tag(s) from the post %PostTitle%. %LineBreak% ID: %PostID% %LineBreak% Type: %PostType% %LineBreak% Status: %PostStatus% %LineBreak% Removed tag(s): %tag% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2121,
						WSAL_INFORMATIONAL,
						'User created new tag',
						'Created the tag %TagName%. %LineBreak% Slug: Slug %LineBreak% View tag: %RevisionLink%',
						'tag',
						'created',
					),
					array(
						2122,
						WSAL_LOW,
						'User deleted tag',
						'Deleted the tag %TagName%. %LineBreak% Slug: Slug',
						'tag',
						'deleted',
					),
					array(
						2123,
						WSAL_INFORMATIONAL,
						'Renamed the tag %old_name% to %new_name%.',
						' %LineBreak% Slug: %Slug% %LineBreak% View tag: %RevisionLink%',
						'tag',
						'renamed',
					),
					array(
						2124,
						WSAL_INFORMATIONAL,
						'User changed tag slug',
						'Changed the slug of the tag %tag% to %new_slug%. %LineBreak% Previous slug: %old_slug% %LineBreak% View tag: %RevisionLink%',
						'tag',
						'modified',
					),
					array(
						2125,
						WSAL_INFORMATIONAL,
						'User changed tag description',
						'Changed the description of the tag %tag%. %LineBreak% Slug: %Slug% %LineBreak% Previous description: %old_desc% %LineBreak% New description: %new_desc% %LineBreak% View tag: %RevisionLink%',
						'tag',
						'modified',
					),
				),
				'Categories'          => array(
					array(
						2016,
						WSAL_LOW,
						'User changed post category',
						'Changed the category(ies) of the post %PostTitle% to %NewCategories%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous category(ies): %OldCategories% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2023,
						WSAL_MEDIUM,
						'User created new category',
						'Created the category %CategoryName%. %LineBreak% Slug: Slug %LineBreak% View category: %CategoryLink%',
						'category',
						'created',
					),
					array(
						2024,
						WSAL_MEDIUM,
						'User deleted category',
						'Deleted the category %CategoryName%. %LineBreak% Slug: Slug',
						'category',
						'deleted',
					),
					array(
						2052,
						WSAL_LOW,
						'Changed the parent of a category',
						'Changed the parent of the category %CategoryName% to %NewParent%. %LineBreak% Slug: %Slug% %LineBreak% Previous parent: %OldParent% %LineBreak% View category: %CategoryLink%',
						'category',
						'modified',
					),
					array(
						2127,
						WSAL_LOW,
						'User changed category name',
						'Renamed the category %old_name% to %new_name%. %LineBreak% Slug: %slug% %LineBreak% View category: %cat_link%',
						'category',
						'renamed',
					),
					array(
						2128,
						WSAL_LOW,
						'User changed category slug',
						'Changed the slug of the category %CategoryName% to %new_slug%. %LineBreak% Previous slug: %old_slug% %LineBreak% View category: %cat_link%',
						'category',
						'modified',
					),
				),
				'Custom Fields'       => array(
					array(
						2053,
						WSAL_LOW,
						'User created a custom field for a post',
						'Created the new custom field %MetaKey% in the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Custom field value: %MetaValue% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% %MetaLink% %LineBreak% URL: %PostUrlIfPlublished%',
						'post',
						'modified',
					),
					array(
						2054,
						WSAL_LOW,
						'User updated a custom field value for a post',
						'Modified the value of the custom field %MetaKey% in the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous custom field value: %MetaValueOld% %LineBreak% New custom field value: %MetaValueNew% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% %MetaLink% %LineBreak% URL: %PostUrlIfPlublished%',
						'custom-field',
						'modified',
					),
					array(
						2055,
						WSAL_MEDIUM,
						'User deleted a custom field from a post',
						'Deleted the custom field %MetaKey% from the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'custom-field',
						'deleted',
					),
					array(
						2062,
						WSAL_LOW,
						'User updated a custom field name for a post',
						'Renamed the custom field %MetaKeyOld% on post %PostTitle% to %MetaKeNew%. %LineBreak% Post: %PostTitle% %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% URL: %PostUrlIfPlublished%',
						'custom-field',
						'renamed',
					),
				),
				'Custom Fields (ACF)' => array(
					array(
						2131,
						WSAL_LOW,
						'User added relationship to a custom field value for a post',
						'Added relationships to the custom field %MetaKey% in the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% New relationships: %Relationships% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% %MetaLink%',
						'custom-field',
						'modified',
					),
					array(
						2132,
						WSAL_LOW,
						'User removed relationship from a custom field value for a post',
						'Removed relationships from the custom field %MetaKey% in the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Removed relationships: %Relationships% %LineBreak% View the post in editor: %EditorLinkPost% %LineBreak% %MetaLink%',
						'custom-field',
						'modified',
					),
				),
				'Comments'            => array(
					array(
						2090,
						WSAL_INFORMATIONAL,
						'User approved a comment',
						'Approved the comment posted by %Author% on the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'approved',
					),
					array(
						2091,
						WSAL_INFORMATIONAL,
						'User unapproved a comment',
						'Unapproved the comment posted by %Author% on the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'unapproved',
					),
					array(
						2092,
						WSAL_INFORMATIONAL,
						'User replied to a comment',
						'Replied to the comment posted by %Author% on the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'created',
					),
					array(
						2093,
						WSAL_LOW,
						'User edited a comment',
						'Edited the comment posted by %Author% on the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'modified',
					),
					array(
						2094,
						WSAL_INFORMATIONAL,
						'User marked a comment as Spam',
						'Marked the comment posted by %Author% on the post %PostTitle% as spam. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'unapproved',
					),
					array(
						2095,
						WSAL_LOW,
						'User marked a comment as Not Spam',
						'Marked the comment posted by %Author% on the post %PostTitle% as not spam. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'approved',
					),
					array(
						2096,
						WSAL_LOW,
						'User moved a comment to trash',
						'Moved the comment posted by %Author% on the post %PostTitle% to trash. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'deleted',
					),
					array(
						2097,
						WSAL_INFORMATIONAL,
						'User restored a comment from the trash',
						'Restored the comment posted by %Author% on the post %PostTitle% from trash. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'restored',
					),
					array(
						2098,
						WSAL_LOW,
						'User permanently deleted a comment',
						'Permanently deleted the comment posted by %Author% on the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'deleted',
					),
					array(
						2099,
						WSAL_INFORMATIONAL,
						'User posted a comment',
						'Posted a comment on the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'created',
					),
					array(
						2126,
						WSAL_INFORMATIONAL,
						'Visitor posted a comment',
						'Posted a comment on the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Comment ID: %CommentID% %LineBreak% Comment: Array %LineBreak% URL: %PostUrlIfPlublished%',
						'comment',
						'created',
					),
				),
				'Widgets'             => array(
					array(
						2042,
						WSAL_MEDIUM,
						'User added a new widget',
						'Added a new %WidgetName% widget in %Sidebar%.',
						'widget',
						'added',
					),
					array(
						2043,
						WSAL_HIGH,
						'User modified a widget',
						'Modified the %WidgetName% widget in %Sidebar%.',
						'widget',
						'modified',
					),
					array(
						2044,
						WSAL_MEDIUM,
						'User deleted widget',
						'Deleted the %WidgetName% widget from %Sidebar%.',
						'widget',
						'deleted',
					),
					array(
						2045,
						WSAL_LOW,
						'User moved widget',
						'Moved the %WidgetName% widget. %LineBreak% From: %OldSidebar% %LineBreak% To: %NewSidebar%',
						'widget',
						'modified',
					),
					array(
						2071,
						WSAL_LOW,
						'User changed widget position',
						'Changed the position of the %WidgetName% widget in %Sidebar%.',
						'widget',
						'modified',
					),
				),
				'Menus'               => array(
					array(
						2078,
						WSAL_LOW,
						'User created new menu',
						'New menu called %MenuName%. %LineBreak% View menu: %MenuUrl%',
						'menu',
						'created',
					),
					array(
						2079,
						WSAL_LOW,
						'User added content to a menu',
						'Added the item %ContentName% to the menu %MenuName%. %LineBreak% Item type: %ContentType% %LineBreak% View menu: %MenuUrl%',
						'menu',
						'modified',
					),
					array(
						2080,
						WSAL_LOW,
						'User removed content from a menu',
						'Removed the item %ContentName% from the menu %MenuName%. %LineBreak% Item type: %ContentType% %LineBreak% View menu: %MenuUrl%',
						'menu',
						'modified',
					),
					array(
						2081,
						WSAL_MEDIUM,
						'User deleted menu',
						'Deleted the menu %MenuName%.',
						'menu',
						'deleted',
					),
					array(
						2082,
						WSAL_LOW,
						'User changed menu setting',
						'The setting %MenuSetting% in the menu %MenuName%. %LineBreak% View menu: %MenuUrl%',
						'menu',
						'enabled',
					),
					array(
						2083,
						WSAL_LOW,
						'User modified content in a menu',
						'Modified the item %ContentName% in the menu %MenuName%. %LineBreak% Item type: %ContentType% %LineBreak% View menu: %MenuUrl%',
						'menu',
						'modified',
					),
					array(
						2084,
						WSAL_LOW,
						'User changed name of a menu',
						'Renamed the menu %OldMenuName% to %MenuName%. %LineBreak% View menu: %MenuUrl%',
						'menu',
						'renamed',
					),
					array(
						2085,
						WSAL_LOW,
						'User changed order of the objects in a menu',
						'Changed the order of the items in the menu %MenuName%. %LineBreak% View menu: %MenuUrl%',
						'menu',
						'modified',
					),
					array(
						2089,
						WSAL_LOW,
						'User moved objects as a sub-item',
						'Moved items as sub-items in the menu %MenuName%. %LineBreak% Moved item: %ItemName% %LineBreak% as a sub-item of: %ParentName% %LineBreak% View menu: %MenuUrl%',
						'menu',
						'modified',
					),
				),
				'Custom Post Types'   => array(
					array(
						2003,
						E_NOTICE,
						'User modified a draft blog post',
						'Modified the draft post with the %PostTitle%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2029,
						E_NOTICE,
						'User created a new post with custom post type and saved it as draft',
						'Created a new custom post called %PostTitle% of type %PostType%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2030,
						E_NOTICE,
						'User published a post with custom post type',
						'Published a custom post %PostTitle% of type %PostType%. Post URL is %PostUrl%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2031,
						E_NOTICE,
						'User modified a post with custom post type',
						'Modified the custom post %PostTitle% of type %PostType%. Post URL is %PostUrl%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2032,
						E_NOTICE,
						'User modified a draft post with custom post type',
						'Modified the draft custom post %PostTitle% of type is %PostType%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2033,
						E_WARNING,
						'User permanently deleted post with custom post type',
						'Permanently Deleted the custom post %PostTitle% of type %PostType%.',
						'',
						'',
					),
					array(
						2034,
						E_WARNING,
						'User moved post with custom post type to trash',
						'Moved the custom post %PostTitle% of type %PostType% to trash. Post URL was %PostUrl%.',
						'',
						'',
					),
					array(
						2035,
						E_CRITICAL,
						'User restored post with custom post type from trash',
						'The custom post %PostTitle% of type %PostType% has been restored from trash. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2036,
						E_NOTICE,
						'User changed the category of a post with custom post type',
						'Changed the category(ies) of the custom post %PostTitle% of type %PostType% from %OldCategories% to %NewCategories%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2037,
						E_NOTICE,
						'User changed the URL of a post with custom post type',
						'Changed the URL of the custom post %PostTitle% of type %PostType% from %OldUrl% to %NewUrl%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2038,
						E_NOTICE,
						'User changed the author or post with custom post type',
						'Changed the author of custom post %PostTitle% of type %PostType% from %OldAuthor% to %NewAuthor%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2039,
						E_NOTICE,
						'User changed the status of post with custom post type',
						'Changed the status of custom post %PostTitle% of type %PostType% from %OldStatus% to %NewStatus%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2040,
						E_WARNING,
						'User changed the visibility of a post with custom post type',
						'Changed the visibility of the custom post %PostTitle% of type %PostType% from %OldVisibility% to %NewVisibility%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2041,
						E_NOTICE,
						'User changed the date of post with custom post type',
						'Changed the date of the custom post %PostTitle% of type %PostType% from %OldDate% to %NewDate%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2056,
						E_CRITICAL,
						'User created a custom field for a custom post type',
						'Created a new custom field %MetaKey% with value %MetaValue% in custom post %PostTitle% of type %PostType%. %EditorLinkPost%.<br>%MetaLink%.',
						'',
						'',
					),
					array(
						2057,
						E_CRITICAL,
						'User updated a custom field for a custom post type',
						'Modified the value of the custom field %MetaKey% from %MetaValueOld% to %MetaValueNew% in custom post %PostTitle% of type %PostType% %EditorLinkPost%.<br>%MetaLink%.',
						'',
						'',
					),
					array(
						2058,
						E_CRITICAL,
						'User deleted a custom field from a custom post type',
						'Deleted the custom field %MetaKey% with id %MetaID% from custom post %PostTitle% of type %PostType% %EditorLinkPost%.<br>%MetaLink%.',
						'',
						'',
					),
					array(
						2063,
						E_CRITICAL,
						'User updated a custom field name for a custom post type',
						'Changed the custom field name from %MetaKeyOld% to %MetaKeyNew% in custom post %PostTitle% of type %PostType% %EditorLinkPost%.<br>%MetaLink%.',
						'',
						'',
					),
					array(
						2067,
						E_WARNING,
						'User modified content for a published custom post type',
						'Modified the content of the published custom post type %PostTitle%. Post URL is %PostUrl%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2068,
						E_NOTICE,
						'User modified content for a draft post',
						'Modified the content of the draft post %PostTitle%.%RevisionLink% %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2070,
						E_NOTICE,
						'User modified content for a draft custom post type',
						'Modified the content of the draft custom post type %PostTitle%.%EditorLinkPost%.',
						'',
						'',
					),
					array(
						2072,
						E_NOTICE,
						'User modified content of a post',
						'Modified the content of post %PostTitle% which is submitted for review.%RevisionLink% %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2076,
						E_NOTICE,
						'User scheduled a custom post type',
						'Scheduled the custom post type %PostTitle% to be published %PublishingDate%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2088,
						E_NOTICE,
						'User changed title of a custom post type',
						'Changed the title of the custom post %OldTitle% to %NewTitle%. %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2104,
						E_NOTICE,
						'User opened a custom post type in the editor',
						'Opened the custom post %PostTitle% of type %PostType% in the editor. View the post: %EditorLinkPost%.',
						'',
						'',
					),
					array(
						2105,
						E_NOTICE,
						'User viewed a custom post type',
						'Viewed the custom post %PostTitle% of type %PostType%. View the post: %PostUrl%.',
						'',
						'',
					),
					array(
						5021,
						E_CRITICAL,
						'A plugin created a custom post',
						'A plugin automatically created the following custom post: %PostTitle%.',
						'',
						'',
					),
					array(
						5027,
						E_CRITICAL,
						'A plugin deleted a custom post',
						'A plugin automatically deleted the following custom post: %PostTitle%.',
						'',
						'',
					),
					array(
						2108,
						E_NOTICE,
						'A plugin modified a custom post',
						'Plugin modified the custom post %PostTitle%. View the post: %EditorLinkPost%.',
						'',
						'',
					),
				),
				'Pages'               => array(
					array(
						2004,
						E_NOTICE,
						'User created a new WordPress page and saved it as draft',
						'Created a new page called %PostTitle% and saved it as draft. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2005,
						E_NOTICE,
						'User published a WordPress page',
						'Published a page called %PostTitle%. Page URL is %PostUrl%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2006,
						E_NOTICE,
						'User modified a published WordPress page',
						'Modified the published page %PostTitle%. Page URL is %PostUrl%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2007,
						E_NOTICE,
						'User modified a draft WordPress page',
						'Modified the draft page %PostTitle%. Page ID is %PostID%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2009,
						E_WARNING,
						'User permanently deleted a page from the trash',
						'Permanently deleted the page %PostTitle%.',
						'',
						'',
					),
					array(
						2013,
						E_WARNING,
						'User moved WordPress page to the trash',
						'Moved the page %PostTitle% to trash. Page URL was %PostUrl%.',
						'',
						'',
					),
					array(
						2015,
						E_CRITICAL,
						'User restored a WordPress page from trash',
						'Page %PostTitle% has been restored from trash. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2018,
						E_NOTICE,
						'User changed page URL',
						'Changed the URL of the page %PostTitle% from %OldUrl% to %NewUrl%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2020,
						E_NOTICE,
						'User changed page author',
						'Changed the author of the page %PostTitle% from %OldAuthor% to %NewAuthor%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2022,
						E_NOTICE,
						'User changed page status',
						'Changed the status of the page %PostTitle% from %OldStatus% to %NewStatus%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2026,
						E_WARNING,
						'User changed the visibility of a page post',
						'Changed the visibility of the page %PostTitle% from %OldVisibility% to %NewVisibility%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2028,
						E_NOTICE,
						'User changed the date of a page post',
						'Changed the date of the page %PostTitle% from %OldDate% to %NewDate%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2059,
						E_CRITICAL,
						'User created a custom field for a page',
						'Created a new custom field called %MetaKey% with value %MetaValue% in the page %PostTitle% %EditorLinkPage%.<br>%MetaLink%.',
						'',
						'',
					),
					array(
						2060,
						E_CRITICAL,
						'User updated a custom field value for a page',
						'Modified the value of the custom field %MetaKey% from %MetaValueOld% to %MetaValueNew% in the page %PostTitle% %EditorLinkPage%.<br>%MetaLink%.',
						'',
						'',
					),
					array(
						2061,
						E_CRITICAL,
						'User deleted a custom field from a page',
						'Deleted the custom field %MetaKey% with id %MetaID% from page %PostTitle% %EditorLinkPage%<br>%MetaLink%.',
						'',
						'',
					),
					array(
						2064,
						E_CRITICAL,
						'User updated a custom field name for a page',
						'Changed the custom field name from %MetaKeyOld% to %MetaKeyNew% in the page %PostTitle% %EditorLinkPage%.<br>%MetaLink%.',
						'',
						'',
					),
					array(
						2066,
						E_WARNING,
						'User modified content for a published page',
						'Modified the content of the published page %PostTitle%. Page URL is %PostUrl%. %RevisionLink% %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2069,
						E_NOTICE,
						'User modified content for a draft page',
						'Modified the content of draft page %PostTitle%.%RevisionLink% %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2075,
						E_NOTICE,
						'User scheduled a page',
						'Scheduled the page %PostTitle% to be published %PublishingDate%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2087,
						E_NOTICE,
						'User changed title of a page',
						'Changed the title of the page %OldTitle% to %NewTitle%. %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2102,
						E_NOTICE,
						'User opened a page in the editor',
						'Opened the page %PostTitle% in the editor. View the page: %EditorLinkPage%.',
						'',
						'',
					),
					array(
						2103,
						E_NOTICE,
						'User viewed a page',
						'Viewed the page %PostTitle%. View the page: %PostUrl%.',
						'',
						'',
					),
					array(
						2113,
						E_NOTICE,
						'User disabled Comments/Trackbacks and Pingbacks on a draft post',
						'Disabled %Type% on the draft post %PostTitle%. View the post: %PostUrl%.',
						'',
						'',
					),
					array(
						2114,
						E_NOTICE,
						'User enabled Comments/Trackbacks and Pingbacks on a draft post',
						'Enabled %Type% on the draft post %PostTitle%. View the post: %PostUrl%.',
						'',
						'',
					),
					array(
						2115,
						E_NOTICE,
						'User disabled Comments/Trackbacks and Pingbacks on a published page',
						'Disabled %Type% on the published page %PostTitle%. View the page: %PostUrl%.',
						'',
						'',
					),
					array(
						2116,
						E_NOTICE,
						'User enabled Comments/Trackbacks and Pingbacks on a published page',
						'Enabled %Type% on the published page %PostTitle%. View the page: %PostUrl%.',
						'',
						'',
					),
					array(
						2117,
						E_NOTICE,
						'User disabled Comments/Trackbacks and Pingbacks on a draft page',
						'Disabled %Type% on the draft page %PostTitle%. View the page: %PostUrl%.',
						'',
						'',
					),
					array(
						2118,
						E_NOTICE,
						'User enabled Comments/Trackbacks and Pingbacks on a draft page',
						'Enabled %Type% on the draft page %PostTitle%. View the page: %PostUrl%.',
						'',
						'',
					),
					array(
						5020,
						E_CRITICAL,
						'A plugin created a page',
						'A plugin automatically created the following page: %PostTitle%.',
						'',
						'',
					),
					array(
						5026,
						E_CRITICAL,
						'A plugin deleted a page',
						'A plugin automatically deleted the following page: %PostTitle%.',
						'',
						'',
					),
					array(
						2107,
						E_NOTICE,
						'A plugin modified a page',
						'Plugin modified the page %PostTitle%. View the page: %EditorLinkPage%.',
						'',
						'',
					),
				),
			),
			'User Accounts'                  => array(
				'User Profiles'           => array(
					array(
						4000,
						WSAL_CRITICAL,
						'New user was created on WordPress',
						'A new user %NewUserData->Username% is created via registration. %LineBreak% User: %NewUserData->Username% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'created',
					),
					array(
						4001,
						WSAL_CRITICAL,
						'User created another WordPress user',
						'Created the new user: %NewUserData->Username%. %LineBreak% Role: %NewUserData->Roles% %LineBreak% First name: %NewUserData->FirstName% %LineBreak% Last name: %NewUserData->LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'created',
					),
					array(
						4002,
						WSAL_CRITICAL,
						'The role of a user was changed by another WordPress user',
						'Changed the role of user %TargetUsername% to %NewRole%. %LineBreak% Previous role: %OldRole% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4003,
						WSAL_HIGH,
						'User has changed his or her password',
						'Changed the password. %LineBreak% Role: %TargetUserData->Roles% %LineBreak% First name: %TargetUserData->FirstName% %LineBreak% Last name: %TargetUserData->LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4004,
						WSAL_HIGH,
						'User changed another user\'s password',
						'Changed the password of the user %TargetUserData->Username%. %LineBreak% Role: %TargetUserData->Roles% %LineBreak% First name: %TargetUserData->FirstName% %LineBreak% Last name: %TargetUserData->LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4005,
						WSAL_MEDIUM,
						'User changed his or her email address',
						'Changed the email address to %NewEmail%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% Previous email address: %OldEmail% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4006,
						WSAL_MEDIUM,
						'User changed another user\'s email address',
						'Changed the email address of the user %TargetUsername% to %NewEmail%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% Previous email address: %OldEmail% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4007,
						WSAL_HIGH,
						'User was deleted by another user',
						'Deleted the user %TargetUserData->Username%. %LineBreak% Role: %TargetUserData->Roles% %LineBreak% First name: %NewUserData->FirstName% %LineBreak% Last name: %NewUserData->LastName%',
						'user',
						'deleted',
					),
					array(
						4014,
						WSAL_INFORMATIONAL,
						'User opened the profile page of another user',
						'Opened the profile page of user %TargetUsername%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'opened',
					),
					array(
						4015,
						WSAL_LOW,
						'User updated a custom field value for a user',
						'Changed the value of the custom field %custom_field_name% in the user profile %TargetUsername%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% Previous value: %old_value% %LineBreak% New value: %new_value% %LineBreak% User profile page: %EditUserLink% %LineBreak% %MetaLink%',
						'user',
						'modified',
					),
					array(
						4016,
						WSAL_LOW,
						'User created a custom field value for a user',
						'Created the custom field %custom_field_name% in the user profile %TargetUsername%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% Custom field value: %new_value% %LineBreak% User profile page: %EditUserLink% %LineBreak% %MetaLink%',
						'user',
						'modified',
					),
					array(
						4017,
						WSAL_INFORMATIONAL,
						'User changed first name for a user',
						'Changed the first name of the user %TargetUsername% to %new_firstname%. %LineBreak% Role: %Roles% %LineBreak% Previous name: %old_firstname% %LineBreak% Last name: %LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4018,
						WSAL_INFORMATIONAL,
						'User changed last name for a user',
						'Changed the last name of the user %TargetUsername% to %new_lastname%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Previous last name: %old_lastname% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4019,
						WSAL_INFORMATIONAL,
						'User changed nickname for a user',
						'Changed the nickname of the user %TargetUsername% to %new_nickname%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% Previous nickname: %old_nickname% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4020,
						WSAL_LOW,
						'User changed the display name for a user',
						'Changed the display name of the user %TargetUsername% to %new_displayname%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% Previous display name: %old_displayname% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4021,
						WSAL_MEDIUM,
						'User\'s website URL was modified',
						'Changed the website URL of the user %TargetUsername% to %new_url%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% Previous website URL: %old_url% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4025,
						WSAL_CRITICAL,
						'User created an application password',
						'The application password %friendly_name%. %LineBreak% Role: %roles% %LineBreak% First name: %firstname% %LineBreak% Last name: %lastname%',
						'user',
						'added',
					),
					array(
						4026,
						WSAL_CRITICAL,
						'User created an application password',
						'The application password %friendly_name% for the user %login%. %LineBreak% Role: %roles% %LineBreak% First name: %firstname% %LineBreak% Last name: %lastname%',
						'user',
						'added',
					),
					array(
						4027,
						WSAL_HIGH,
						'User revoked all application passwords',
						'All application passwords. %LineBreak% Role: %roles% %LineBreak% First name: %firstname% %LineBreak% Last name: %lastname%',
						'user',
						'revoked',
					),
					array(
						4028,
						WSAL_HIGH,
						'User revoked all application passwords for a user',
						'All application passwords from the user %login%. %LineBreak% Role: %roles% %LineBreak% First name: %firstname% %LineBreak% Last name: %lastname%',
						'user',
						'revoked',
					),
					array(
						4029,
						WSAL_HIGH,
						'Admin sent a password reset request to a user',
						'Sent a password reset request to the user %login%. %LineBreak% Role: %roles% %LineBreak% First name: %firstname% %LineBreak% Last name: %lastname%',
						'user',
						'submitted',
					),
				),
				'Multisite User Profiles' => array(
					array(
						4008,
						WSAL_CRITICAL,
						'User granted Super Admin privileges',
						'Granted Super Admin privileges to the user %TargetUsername%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4009,
						WSAL_CRITICAL,
						'User revoked from Super Admin privileges',
						'Revoked Super Admin privileges from %TargetUsername%. %LineBreak% Role: %Roles% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4010,
						WSAL_MEDIUM,
						'Existing user added to a site',
						'Added user %TargetUsername% to the site %SiteName%. %LineBreak% Role: %TargetUserRole% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4011,
						WSAL_MEDIUM,
						'User removed from site',
						'Removed user %TargetUsername% from the site %SiteName% %LineBreak% Site role: %TargetUserRole% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						4012,
						WSAL_CRITICAL,
						'New network user created',
						'Created the new network user %NewUserData->Username%. %LineBreak% First name: %NewUserData->FirstName% %LineBreak% Last name: %NewUserData->LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'created',
					),
					array(
						4013,
						WSAL_HIGH,
						'Network user has been activated',
						'User %NewUserData->Username% has been activated. %LineBreak% Role: %NewUserData->Roles% %LineBreak% First name: %NewUserData->FirstName% %LineBreak% Last name: %NewUserData->LastName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'activated',
					),
					array(
						4024,
						WSAL_LOW,
						'Network user has signed-up',
						'User with the email address %email_address% has signed up to the network. %LineBreak% Username: %username%',
						'user',
						'created',
					),
				),
			),
			'Plugins & Themes'               => array(
				'Plugins'             => array(
					array(
						5000,
						WSAL_CRITICAL,
						'User installed a plugin',
						'Installed the plugin %Plugin->Name%. %LineBreak% Version: %Plugin->Version% %LineBreak% Install location: %Plugin->plugin_dir_path%',
						'plugin',
						'installed',
					),
					array(
						5001,
						WSAL_HIGH,
						'User activated a WordPress plugin',
						'Activated the plugin %PluginData->Name%. %LineBreak% Version: %PluginData->Version% %LineBreak% Install location: %PluginFile%',
						'plugin',
						'activated',
					),
					array(
						5002,
						WSAL_HIGH,
						'User deactivated a WordPress plugin',
						'Deactivated the plugin %PluginData->Name%. %LineBreak% Version: %PluginData->Version% %LineBreak% Install location: %PluginFile%',
						'plugin',
						'deactivated',
					),
					array(
						5003,
						WSAL_HIGH,
						'User uninstalled a plugin',
						'Uninstalled the plugin %PluginData->Name%. %LineBreak% Version: %PluginData->Version% %LineBreak% Install location: %PluginFile%',
						'plugin',
						'uninstalled',
					),
					array(
						5004,
						WSAL_LOW,
						'User upgraded a plugin',
						'Updated the plugin %PluginData->Name%. %LineBreak% Updated version: %PluginData->Version% %LineBreak% Install location: %PluginFile%',
						'plugin',
						'updated',
					),
					array(
						5019,
						WSAL_MEDIUM,
						'A plugin created a post',
						'The plugin created the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Plugin: %PluginName% %LineBreak% View page in the editor: %EditorLinkPage%',
						'post',
						'created',
					),
					array(
						5025,
						WSAL_LOW,
						'A plugin deleted a post',
						'A plugin deleted the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Plugin: %PluginName%',
						'post',
						'deleted',
					),
					array(
						5028,
						WSAL_MEDIUM,
						'Changed the Automatic updates setting for a plugin.',
						'Changed the Automatic updates setting for the plugin %name%. %LineBreak% Install location: %install_directory%',
						'plugin',
						'enabled',
					),
					array(
						5029,
						WSAL_MEDIUM,
						'Changed the Automatic updates setting for a theme.',
						'Changed the Automatic updates setting for the theme %name%. %LineBreak% Install location: %install_directory%',
						'theme',
						'enabled',
					),
					array(
						2051,
						WSAL_HIGH,
						'User changed a file using the plugin editor',
						'Modified the file %File% with the plugin editor.',
						'file',
						'modified',
					),
				),
				'Themes'              => array(
					array(
						5005,
						WSAL_CRITICAL,
						'User installed a theme',
						'Installed the theme %Theme->Name%. %LineBreak% Version: %Theme->Version% %LineBreak% Install location: %Theme->get_template_directory% %LineBreak% ',
						'theme',
						'installed',
					),
					array(
						5006,
						WSAL_HIGH,
						'User activated a theme',
						'Activated the theme %Theme->Name%. %LineBreak% Version: %Theme->Version% %LineBreak% Install location: %Theme->get_template_directory%',
						'theme',
						'activated',
					),
					array(
						5007,
						WSAL_HIGH,
						'User uninstalled a theme',
						'Deleted the theme %Theme->Name%. %LineBreak% Version: %Theme->Version% %LineBreak% Install location: %Theme->get_template_directory%',
						'theme',
						'deleted',
					),
					array(
						5031,
						WSAL_LOW,
						'User updated a theme',
						'Updated the theme %Theme->Name%. %LineBreak% New version: %Theme->Version% %LineBreak% Install location: %Theme->get_template_directory%',
						'theme',
						'updated',
					),
					array(
						2046,
						WSAL_HIGH,
						'User changed a file using the theme editor',
						'Modified the file %Theme%/%File% with the theme editor.',
						'file',
						'modified',
					),
				),
				'Themes on Multisite' => array(
					array(
						5008,
						WSAL_HIGH,
						'Activated theme on network',
						'Network activated the theme %Theme->Name%. %LineBreak% Version: %Theme->Version% %LineBreak% Install location: %Theme->get_template_directory%',
						'theme',
						'activated',
					),
					array(
						5009,
						WSAL_MEDIUM,
						'Deactivated theme from network',
						'Network deactivated the theme %Theme->Name%. %LineBreak% Version: %Theme->Version% %LineBreak% Install location: %Theme->get_template_directory%',
						'theme',
						'deactivated',
					),
				),
			),
			'WordPress & System'             => array(
				'System'                       => array(
					array(
						0,
						E_CRITICAL,
						'Unknown Error',
						'An unexpected error has occurred.',
						'',
						'',
					),
					array(
						1,
						E_CRITICAL,
						'PHP error',
						'%Message%.',
						'',
						'',
					),
					array(
						2,
						E_WARNING,
						'PHP warning',
						'%Message%.',
						'',
						'',
					),
					array(
						3,
						E_NOTICE,
						'PHP notice',
						'%Message%.',
						'',
						'',
					),
					array(
						4,
						E_CRITICAL,
						'PHP exception',
						'%Message%.',
						'',
						'',
					),
					array(
						5,
						E_CRITICAL,
						'PHP shutdown error',
						'%Message%.',
						'',
						'',
					),
					array(
						6004,
						WSAL_MEDIUM,
						'WordPress was updated',
						'Updated WordPress. %LineBreak% Previous version: %OldVersion% %LineBreak% New version: %NewVersion%',
						'system',
						'updated',
					),
					array(
						9999,
						E_CRITICAL,
						'Advertising Extensions',
						'%PromoName% %PromoMessage%',
						'',
						'',
					),
				),
				'Activity log plugin'          => array(
					array(
						6000,
						WSAL_INFORMATIONAL,
						'Events automatically pruned by system',
						'System automatically deleted %EventCount% events from the activity log.',
						'wp-activity-log',
						'deleted',
					),
					array(
						6006,
						WSAL_MEDIUM,
						'Reset the plugin\'s settings to default',
						'Reset the activity log plugin\'s settings to default.',
						'wp-activity-log',
						'modified',
					),
					array(
						6034,
						WSAL_CRITICAL,
						'Purged the activity log',
						'Purged the activity log.',
						'wp-activity-log',
						'deleted',
					),
					array(
						6038,
						WSAL_CRITICAL,
						'Deleted all the data about a user from the activity log.',
						'Deleted all the data about the user <strong>%user%</strong> from the activity log. %LineBreak% Role: %Role% %LineBreak% First name: %FirstName% %LineBreak% Last name: %LastName%',
						'wp-activity-log',
						'deleted',
					),
					array(
						6039,
						WSAL_CRITICAL,
						'Deleted all the data of a specific type from the activity log.',
						'Deleted all the data about the %deleted_data_type% %deleted_data% from the activity log.',
						'wp-activity-log',
						'deleted',
					),
					array(
						6043,
						WSAL_HIGH,
						'Some WP Activity Log plugin settings on this site were propagated and overridden from the MainWP dashboard',
						'Some <strong>WP Activity Log</strong> plugin settings on this site were propagated and overridden from the MainWP dashboard.',
						'wp-activity-log',
						'modified',
					),
					array(
						6046,
						WSAL_LOW,
						'Changed the status of the Login Page Notification',
						'Changed the status of the <strong>Login Page Notification.</strong>',
						'wp-activity-log',
						'enabled',
					),
					array(
						6047,
						WSAL_LOW,
						'Changed the text of the Login Page Notification',
						'Changed the text of the <strong>Login Page Notification.</strong>',
						'wp-activity-log',
						'modified',
					),
					array(
						6048,
						WSAL_LOW,
						'Changed the status of the Reverse proxy / firewall option',
						'Changed the status of the <strong>Reverse proxy / firewall option.</strong>',
						'wp-activity-log',
						'enabled',
					),
					array(
						6049,
						WSAL_HIGH,
						'Changed the Restrict plugin access setting',
						'Changed the <strong>Restrict plugin access</strong> setting to %new_setting%. %LineBreak% Previous setting: %previous_setting%',
						'wp-activity-log',
						'modified',
					),
					array(
						6050,
						WSAL_HIGH,
						'The user %user% to / from the list of users who can view the activity log',
						'The user %user% to / from the list of users who can view the activity log. %LineBreak% Previous list of users who had access to view the activity log: %previous_users%',
						'wp-activity-log',
						'added',
					),
					array(
						6051,
						WSAL_MEDIUM,
						'Changed the status of the Hide plugin in plugins page setting',
						'Changed the status of the <strong>Hide plugin in plugins page</strong> setting.',
						'wp-activity-log',
						'enabled',
					),
					array(
						6052,
						WSAL_HIGH,
						'Changed the Activity log retention setting',
						'Changed the <strong>Activity log retention</strong> to %new_setting%. %LineBreak% Previous setting: %previous_setting%',
						'wp-activity-log',
						'modified',
					),
					array(
						6053,
						WSAL_LOW,
						'A user was added to / from the list of excluded users from the activity log',
						'The user %user% to / from the list of excluded users from the activity log. %LineBreak% Previous list of users: %previous_users%',
						'wp-activity-log',
						'added',
					),
					array(
						6054,
						WSAL_LOW,
						'A user role was added to / from the list of excluded roles from the activity log',
						'The user role %role% to / from the list of excluded roles from the activity log. %LineBreak% Previous list of users: %previous_users%',
						'wp-activity-log',
						'added',
					),
					array(
						6055,
						WSAL_LOW,
						'An IP address was added to / from the list of excluded IP addresses from the activity log',
						'The IP address %ip% to / from the list of excluded IP addresses from the activity log. %LineBreak% Previous list of IPs: %previous_ips%',
						'wp-activity-log',
						'added',
					),
					array(
						6056,
						WSAL_LOW,
						'A post type was added to / from the list of excluded post types from the activity log',
						'The post type %post_type% to / from the list of excluded post types from the activity log. %LineBreak% Previous list of Post types: %previous_types%',
						'wp-activity-log',
						'added',
					),
					array(
						6057,
						WSAL_LOW,
						'A custom field was added to / from the list of excluded custom fields from the activity log',
						'The custom field %custom_field% to / from the list of excluded custom fields from the activity log. %LineBreak% Previous list of Custom fields: %previous_fields%',
						'wp-activity-log',
						'added',
					),
					array(
						6058,
						WSAL_LOW,
						'A custom field was added to / from the list of excluded user profile custom fields from the activity log',
						'The custom field %custom_field% to / from the list of excluded user profile custom fields from the activity log. %LineBreak% Previous list of user profile Custom fields: %previous_fields%',
						'wp-activity-log',
						'added',
					),
				),
				'Notifications & Integrations' => array(
					array(
						6310,
						WSAL_LOW,
						'Changed the status of the Daily Summary of Activity Log',
						'Changed the status of the <strong>Daily Summary of Activity Log.</strong>.',
						'wp-activity-log',
						'enabled',
					),
					array(
						6311,
						WSAL_LOW,
						'Modified the reciepients of the Daily Summary of Activity Log.',
						'Modified the reciepients of the <strong>Daily Summary of Activity Log</strong>. %LineBreak% New recipient: %recipient% %LineBreak% Previous recipient: %previous_recipient%',
						'wp-activity-log',
						'modified',
					),
					array(
						6312,
						WSAL_LOW,
						'Changed the status of a built in notification',
						'Changed the status of the built in notification %notification_name%.',
						'wp-activity-log',
						'enabled',
					),
					array(
						6313,
						WSAL_LOW,
						'Modified the recipient(s) of the built a notification',
						'Modified the recipient(s) of the built in notification %notification_name%. %LineBreak% New recipient(s): %recipient% %LineBreak% Previous recipient(s): %previous_recipient%',
						'wp-activity-log',
						'added',
					),
					array(
						6314,
						WSAL_LOW,
						'Added a new custom notification',
						'Added a new custom notification %notification_name%. %LineBreak% Recipient(s): %recipient%',
						'wp-activity-log',
						'added',
					),
					array(
						6315,
						WSAL_LOW,
						'Modified a custom notification',
						'Modified the custom notification %notification_name%. %LineBreak% Recipient(s): %recipient%',
						'wp-activity-log',
						'modified',
					),
					array(
						6316,
						WSAL_LOW,
						'Changed the status of a custom notification',
						'Changed the status of the custom notification %notification_name%.',
						'wp-activity-log',
						'enabled',
					),
					array(
						6317,
						WSAL_LOW,
						'Deleted a custom notification',
						'Deleted the custom notification %notification_name%.',
						'wp-activity-log',
						'deleted',
					),
					array(
						6318,
						WSAL_LOW,
						'Modified a default notification template',
						'Modified the default %template_name% notification template.',
						'wp-activity-log',
						'modified',
					),
					array(
						6320,
						WSAL_HIGH,
						'Added a new integrations connection',
						'Added / removed the integrations connection %name% %LineBreak% Connection type: %type%',
						'wp-activity-log',
						'added',
					),
					array(
						6321,
						WSAL_HIGH,
						'Modified an integrations connection',
						'Modified the integrations connection %name%. %LineBreak% Connection type: %type%',
						'wp-activity-log',
						'modified',
					),
					array(
						6322,
						WSAL_HIGH,
						'Deleted a integrations connection',
						'Deleted the integrations connection %name%.',
						'wp-activity-log',
						'deleted',
					),
					array(
						6323,
						WSAL_HIGH,
						'Added a new activity log mirror',
						'Added a new activity log mirror %name%. %LineBreak% Connection used by this mirror: %connection%',
						'wp-activity-log',
						'added',
					),
					array(
						6324,
						WSAL_HIGH,
						'Modified an activity log mirror',
						'Modified the activity log mirror %name%. %LineBreak% Connection used by this mirror: %connection%',
						'wp-activity-log',
						'modified',
					),
					array(
						6325,
						WSAL_LOW,
						'Changed the status of an activity log mirror',
						'Changed the status of the activity log mirror %name%. %LineBreak% Connection used by this mirror: %connection%',
						'wp-activity-log',
						'deleted',
					),
					array(
						6326,
						WSAL_HIGH,
						'Deleted an activity log mirror',
						'Deleted the activity log mirror %name%.',
						'wp-activity-log',
						'deleted',
					),
					array(
						6327,
						WSAL_HIGH,
						'Changed the status of Logging of events to the database',
						'Changed the status of <strong>Logging of events to the database</strong>.',
						'wp-activity-log',
						'enabled',
					),
				),
				'WordPress Site Settings'      => array(
					array(
						6001,
						WSAL_CRITICAL,
						'Option Anyone Can Register in WordPress settings changed',
						'The <strong>Membership</strong> setting <strong>Anyone can register</strong>.',
						'system-setting',
						'enabled',
					),
					array(
						6002,
						WSAL_CRITICAL,
						'New User Default Role changed',
						'Changed the <strong>New user default role</strong> WordPress setting. %LineBreak% Previous role: %OldRole% %LineBreak% New role: %NewRole%',
						'system-setting',
						'modified',
					),
					array(
						6003,
						WSAL_CRITICAL,
						'WordPress Administrator Notification email changed',
						'Change the <strong>Administrator email address</strong> in the WordPress settings. %LineBreak% Previous address: %OldEmail% %LineBreak% New address: %NewEmail%',
						'system-setting',
						'modified',
					),
					array(
						6005,
						WSAL_HIGH,
						'User changes the WordPress Permalinks',
						'Changed the <strong>WordPress permalinks</strong>. %LineBreak% Previous permalinks: %OldPattern% %LineBreak% New permalinks: %NewPattern%',
						'system-setting',
						'modified',
					),
					array(
						6008,
						WSAL_INFORMATIONAL,
						'Enabled/Disabled the option Discourage search engines from indexing this site',
						'Changed the status of the WordPress setting <strong>Search engine visibility</strong> (Discourage search engines from indexing this site)',
						'system-setting',
						'enabled',
					),
					array(
						6009,
						WSAL_MEDIUM,
						'Enabled/Disabled comments on all the website',
						'Changed the status of the WordPress setting <strong>Allow people to submit comments on new posts</strong>.',
						'system-setting',
						'enabled',
					),
					array(
						6010,
						WSAL_MEDIUM,
						'Enabled/Disabled the option Comment author must fill out name and email',
						'Changed the status of the WordPress setting <strong>.Comment author must fill out name and email</strong>.',
						'system-setting',
						'enabled',
					),
					array(
						6011,
						WSAL_MEDIUM,
						'Enabled/Disabled the option Users must be logged in and registered to comment',
						'Changed the status of the WordPress setting <strong>Users must be registered and logged in to comment</strong>.',
						'system-setting',
						'enabled',
					),
					array(
						6012,
						WSAL_INFORMATIONAL,
						'Enabled/Disabled the option to automatically close comments',
						'Changed the status of the WordPress setting <strong>Automatically close comments after %Value% days</strong>.',
						'system-setting',
						'enabled',
					),
					array(
						6013,
						WSAL_INFORMATIONAL,
						'Changed the value of the option Automatically close comments',
						'Changed the value of the WordPress setting <strong>Automatically close comments after a number of days</strong> to %NewValue%. %LineBreak% Previous value: %OldValue%',
						'system-setting',
						'modified',
					),
					array(
						6014,
						WSAL_MEDIUM,
						'Enabled/Disabled the option for comments to be manually approved',
						'Changed the value of the WordPress setting <strong>Comments must be manualy approved</strong>.',
						'system-setting',
						'enabled',
					),
					array(
						6015,
						WSAL_LOW,
						'Enabled/Disabled the option for an author to have previously approved comments for the comments to appear',
						'Changed the value of the WordPress setting <strong>Comment author must have a previously approved comment</strong>.',
						'system-setting',
						'enabled',
					),
					array(
						6016,
						WSAL_LOW,
						'Changed the number of links that a comment must have to be held in the queue',
						'Changed the value of the WordPress setting <strong>Hold a comment in the queue if it contains links</strong> to %NewValue% links. %LineBreak% Previous value: %OldValue%',
						'system-setting',
						'modified',
					),
					array(
						6017,
						WSAL_INFORMATIONAL,
						'Modified the list of keywords for comments moderation',
						'Modified the list of keywords for comments moderation in WordPress.',
						'system-setting',
						'modified',
					),
					array(
						6018,
						WSAL_INFORMATIONAL,
						'Modified the list of keywords for comments blacklisting',
						'Modified the list of <strong>Disallowed comment keys</strong> (keywords) for comments blacklisting in WordPress.',
						'system-setting',
						'modified',
					),
					array(
						6024,
						WSAL_CRITICAL,
						'Option WordPress Address (URL) in WordPress settings changed',
						'Changed the <strong>WordPress address (URL)</strong> tp %new_url%. %LineBreak% Previous URL: %old_url%',
						'system-setting',
						'modified',
					),
					array(
						6025,
						WSAL_CRITICAL,
						'Option Site Address (URL) in WordPress settings changed',
						'Changed the <strong>Site address (URL)</strong> to %new_url%. %LineBreak% Previous URL: %old_url%',
						'system-setting',
						'modified',
					),
					array(
						6035,
						WSAL_CRITICAL,
						'Option Your homepage displays in WordPress settings changed',
						'Changed the <strong>Your homepage displays</strong> WordPress setting to %new_homepage%. %LineBreak% Previous setting: %old_homepage%',
						'system-setting',
						'modified',
					),
					array(
						6036,
						WSAL_CRITICAL,
						'Option homepage in WordPress settings changed',
						'Changed the <strong>Homepage</strong> in the WordPress settings to %new_page%. %LineBreak% Previous page: %old_page%',
						'system-setting',
						'modified',
					),
					array(
						6037,
						WSAL_CRITICAL,
						'Option posts page in WordPress settings changed',
						'Changed the <strong> Posts</strong>  page in the WordPress settings to %new_page%. %LineBreak% Previous page: %old_page%',
						'system-setting',
						'modified',
					),
					array(
						6040,
						WSAL_CRITICAL,
						'Option Timezone in WordPress settings changed',
						'Changed the <strong>Timezone</strong> in the WordPress settings to %new_timezone%. %LineBreak% Previous timezone: %old_timezone%',
						'system-setting',
						'modified',
					),
					array(
						6041,
						WSAL_CRITICAL,
						'Option Date format in WordPress settings changed',
						'Changed the <strong>Date format</strong> in the WordPress settings to %new_date_format%. %LineBreak% Previous format: %old_date_format%',
						'system-setting',
						'modified',
					),
					array(
						6042,
						WSAL_CRITICAL,
						'Option Time format in WordPress settings changed',
						'Changed the <strong>Time format</strong> in the WordPress settings to %new_time_format%. %LineBreak% Previous format: %old_time_format%',
						'system-setting',
						'modified',
					),
					array(
						6044,
						WSAL_HIGH,
						'Option Automatic updates setting changed',
						'Changed the <strong>Automatic updates</strong> setting. %LineBreak% New setting status: %updates_status%',
						'system-setting',
						'modified',
					),
					array(
						6045,
						WSAL_HIGH,
						'Option Site Language setting changed',
						'Changed the <strong>Site Language</strong> to %new_value%. %LineBreak% Previous setting: %previous_value%',
						'system-setting',
						'modified',
					),
					array(
						6059,
						WSAL_HIGH,
						'Option Site Title changed',
						'Changed the <strong>Site Title</strong> to %new_value%. %LineBreak% Previous setting: %previous_value%',
						'system-setting',
						'modified',
					),
				),
				'Database Events'              => array(
					array(
						5010,
						WSAL_LOW,
						'Plugin created table',
						'The plugin %Plugin->Name% created this table in the database. %LineBreak% Table: %TableNames%',
						'database',
						'created',
					),
					array(
						5011,
						WSAL_LOW,
						'Plugin modified table structure',
						'The plugin %Plugin->Name% modified the structure of a database table. %LineBreak% Table: %TableNames%',
						'database',
						'modified',
					),
					array(
						5012,
						WSAL_MEDIUM,
						'Plugin deleted table',
						'The plugin %Plugin->Name% deleted this table from the database. %LineBreak% Table: %TableNames%',
						'database',
						'deleted',
					),
					array(
						5013,
						WSAL_LOW,
						'Theme created tables',
						'The theme %Theme->Name% created this tables in the database. %LineBreak% Table: %TableNames%',
						'database',
						'created',
					),
					array(
						5014,
						WSAL_LOW,
						'Theme modified tables structure',
						'The theme %Theme->Name% modified the structure of this database table %LineBreak% Table: %TableNames%',
						'database',
						'modified',
					),
					array(
						5015,
						WSAL_MEDIUM,
						'Theme deleted tables',
						'The theme %Theme->Name% deleted this table from the database. %LineBreak% Tables: %TableNames%',
						'database',
						'deleted',
					),
					array(
						5016,
						WSAL_HIGH,
						'Unknown component created tables',
						'An unknown component created these tables in the database. %LineBreak% Tables: %TableNames%',
						'database',
						'created',
					),
					array(
						5017,
						WSAL_HIGH,
						'Unknown component modified tables structure',
						'An unknown component modified the structure of these database tables. %LineBreak% Tables: %TableNames%',
						'database',
						'modified',
					),
					array(
						5018,
						WSAL_HIGH,
						'Unknown component deleted tables',
						'An unknown component deleted these tables from the database. %LineBreak% Tables: %TableNames%',
						'database',
						'deleted',
					),
					array(
						5022,
						WSAL_HIGH,
						'WordPress created tables',
						'WordPress has created these tables in the database. %LineBreak% Tables: %TableNames%',
						'database',
						'created',
					),
					array(
						5023,
						WSAL_HIGH,
						'WordPress modified tables structure',
						'WordPress modified the structure of these database tables. %LineBreak% Tables: %TableNames%',
						'database',
						'modified',
					),
					array(
						5024,
						WSAL_HIGH,
						'WordPress deleted tables',
						'WordPress deleted these tables from the database. %LineBreak% Tables: %TableNames%',
						'database',
						'deleted',
					),
				),
			),
			'Multisite Network Sites'        => array(
				'MultiSite' => array(
					array(
						7000,
						WSAL_CRITICAL,
						'New site added on the network',
						'Added the new site %SiteName% to the network. %LineBreak% URL: %BlogURL%',
						'multisite-network',
						'added',
					),
					array(
						7001,
						WSAL_HIGH,
						'Existing site archived',
						'Archived the site %SiteName% on the network. %LineBreak% URL: %BlogURL%',
						'multisite-network',
						'modified',
					),
					array(
						7002,
						WSAL_HIGH,
						'Archived site has been unarchived',
						'Unarchived the site %SiteName%. %LineBreak% URL: %BlogURL%',
						'multisite-network',
						'modified',
					),
					array(
						7003,
						WSAL_HIGH,
						'Deactivated site has been activated',
						'Activated the site %SiteName% on the network. %LineBreak% URL: %BlogURL%',
						'multisite-network',
						'activated',
					),
					array(
						7004,
						WSAL_HIGH,
						'Site has been deactivated',
						'Deactiveated the site %SiteName% on the network. %LineBreak% URL: %BlogURL%',
						'multisite-network',
						'deactivated',
					),
					array(
						7005,
						WSAL_HIGH,
						'Existing site deleted from network',
						'The site: %SiteName%. %LineBreak% URL: %BlogURL%',
						'multisite-network',
						'deleted',
					),
					array(
						7007,
						WSAL_CRITICAL,
						'Allow site administrators to add new users to their sites settings changed',
						'Changed the status of the network setting <strong>Allow site administrators to add new users to their sites</strong>.',
						'multisite-network',
						'enabled',
					),
					array(
						7008,
						WSAL_HIGH,
						'Site upload space settings changed',
						'Changed the status of the network setting <strong>Site upload space</strong> (to limit space allocated for each site\'s upload directory).',
						'multisite-network',
						'enabled',
					),
					array(
						7009,
						WSAL_MEDIUM,
						'Site upload space file size settings changed',
						'Changed the file size in the <strong>Site upload space</strong> network setting to %new_value%. %LineBreak% Previous size (MB): %old_value%',
						'multisite-network',
						'modified',
					),
					array(
						7010,
						WSAL_CRITICAL,
						'Site Upload file types settings changed',
						'Changed the network setting <strong>Upload file types (list of allowed file types)</strong>. %LineBreak% Previous value: %old_value% %LineBreak% New value: %new_value%',
						'multisite-network',
						'modified',
					),
					array(
						7011,
						WSAL_CRITICAL,
						'Site Max upload file size settings changed',
						'Changed the <strong>Max upload file size</strong> network setting to %new_value%. %LineBreak% Previous size (KB): %old_value%',
						'multisite-network',
						'modified',
					),
					array(
						7012,
						WSAL_HIGH,
						'Allow new registrations settings changed',
						'Changed the <strong>Allow new registrations</strong> setting to %new_setting%. %LineBreak% Previous setting: %previous_setting%',
						'multisite-network',
						'modified',
					),
				),
			),
			'Yoast SEO'                      => array(
				'Post Changes'            => array(
					array(
						8801,
						WSAL_INFORMATIONAL,
						'User changed title of a post',
						'Changed the <strong>SEO title</strong> of the post %PostTitle% to %NewSEOTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous title: %OldSEOTitle% %LineBreak% View the post in editor: %EditorLinkPost%',
						'yoast-seo-metabox',
						'modified',
					),
					array(
						8802,
						WSAL_INFORMATIONAL,
						'User changed the meta description of a post',
						'Changed the <strong>Meta description</strong> of the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous description: %old_desc% %LineBreak% New description: %new_desc% %LineBreak% View the post in editor: %EditorLinkPost%',
						'yoast-seo-metabox',
						'modified',
					),
					array(
						8803,
						WSAL_INFORMATIONAL,
						'User changed setting to allow search engines to show post in search results of a post',
						'Changed the setting <strong>Allow seach engines to show post in search results</strong> for the post %PostTitle% to %NewStatus%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous setting: %OldStatus% %LineBreak% View the post in editor: %EditorLinkPost%',
						'yoast-seo-metabox',
						'modified',
					),
					array(
						8804,
						WSAL_INFORMATIONAL,
						'User Enabled/Disabled the option for search engine to follow links of a post',
						'Changed the status of the setting <strong>Search engines to follow links in post</strong> in the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost%',
						'yoast-seo-metabox',
						'enabled',
					),
					array(
						8805,
						WSAL_LOW,
						'User set the Meta robots advanced setting of a post',
						'Changed the <strong>Meta robots advanced</strong> setting for the post %PostTitle% to %NewStatus%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous setting: %OldStatus% %LineBreak% View the post in editor: %EditorLinkPost%',
						'yoast-seo-metabox',
						'modified',
					),
					array(
						8806,
						WSAL_INFORMATIONAL,
						'User changed the canonical URL of a post',
						'Changed the <strong>Canonical URL</strong> of the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous URL: %OldCanonicalUrl% %LineBreak% New URL: %NewCanonicalUrl% %LineBreak% View the post in editor: %EditorLinkPost%',
						'yoast-seo-metabox',
						'modified',
					),
					array(
						8807,
						WSAL_INFORMATIONAL,
						'User changed the focus keyword of a post',
						'Changed the <strong>focus keyword</strong> for the post %PostTitle% to %new_keywords%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% Previous keyword: %old_keywords% %LineBreak% View the post in editor: %EditorLinkPost%',
						'yoast-seo-metabox',
						'modified',
					),
					array(
						8808,
						WSAL_INFORMATIONAL,
						'User Enabled/Disabled the option Cornerston Content of a post',
						'Changed the setting <strong>Cornerstone content</strong> in the post %PostTitle%. %LineBreak% Post ID: %PostID% %LineBreak% Post type: %PostType% %LineBreak% Post status: %PostStatus% %LineBreak% View the post in editor: %EditorLinkPost%',
						'yoast-seo-metabox',
						'enabled',
					),
				),
				'Website Changes'         => array(
					array(
						8809,
						WSAL_INFORMATIONAL,
						'User changed the Title Separator',
						'Changed the <strong>Title separator</strong> in the plugin settings to %new%. %LineBreak% Previous separator: %old%',
						'yoast-seo',
						'modified',
					),
					array(
						8810,
						WSAL_MEDIUM,
						'User changed the Homepage Title',
						'Changed the <strong>Knowledge Graph & Schema.org</strong> in the plugin settings to %new%. %LineBreak% Previous title: %old%',
						'yoast-seo',
						'modified',
					),
					array(
						8811,
						WSAL_MEDIUM,
						'User changed the Homepage Meta description',
						'Changed the homepage Meta description. %LineBreak% Previous description: %old% %LineBreak% New description: %new%',
						'yoast-seo',
						'modified',
					),
					array(
						8812,
						WSAL_INFORMATIONAL,
						'User changed the Knowledge Graph & Schema.org',
						'Changed the <strong>Knowledge Graph & Schema.org</strong> in the plugin settings to %new%. %LineBreak% Previous setting: %old%',
						'yoast-seo',
						'modified',
					),
				),
				'Plugin Settings Changes' => array(
					array(
						8815,
						WSAL_MEDIUM,
						'User Enabled/Disabled SEO analysis in the Yoast SEO plugin settings',
						'Changed the status of the <strong>SEO Analysis</strong> plugin feature.',
						'yoast-seo',
						'enabled',
					),
					array(
						8816,
						WSAL_MEDIUM,
						'User Enabled/Disabled readability analysis in the Yoast SEO plugin settings',
						'Changed the <strong>Readability Analysis</strong> plugin feature.',
						'yoast-seo',
						'enabled',
					),
					array(
						8817,
						WSAL_MEDIUM,
						'User Enabled/Disabled cornerstone content in the Yoast SEO plugin settings',
						'Changed the <strong>Cornerstone content</strong> plugin feature.',
						'yoast-seo',
						'enabled',
					),
					array(
						8818,
						WSAL_MEDIUM,
						'User Enabled/Disabled the text link counter in the Yoast SEO plugin settings',
						'Changed the <strong>Text link counter</strong> plugin feature.',
						'yoast-seo',
						'enabled',
					),
					array(
						8819,
						WSAL_MEDIUM,
						'User Enabled/Disabled XML sitemaps in the Yoast SEO plugin settings',
						'Changed the <strong>XML sitemap</strong> plugin feature.',
						'yoast-seo',
						'enabled',
					),
					array(
						8820,
						WSAL_MEDIUM,
						'User Enabled/Disabled ryte integration in the Yoast SEO plugin settings',
						'Changed the <strong>Ryte integration</strong> plugin feature.',
						'yoast-seo',
						'enabled',
					),
					array(
						8821,
						WSAL_MEDIUM,
						'User Enabled/Disabled the admin bar menu in the Yoast SEO plugin settings',
						'Changed the <strong>Admin bar menu</strong> plugin feature.',
						'yoast-seo',
						'enabled',
					),
					array(
						8822,
						WSAL_INFORMATIONAL,
						'User changed the Posts/Pages meta description template in the Yoast SEO plugin settings',
						'Changed the %SEOPostType% Meta description template to %new%. %LineBreak% Previous template: %old%',
						'yoast-seo',
						'modified',
					),
					array(
						8824,
						WSAL_LOW,
						'User set the option to show the Yoast SEO Meta Box for Posts/Pages in the Yoast SEO plugin settings',
						'Changed the status of the option to show the <strong>Yoast SEO Meta Box</strong> for %SEOPostType%.',
						'yoast-seo',
						'enabled',
					),
					array(
						8825,
						WSAL_LOW,
						'User Enabled/Disabled the advanced or schema settings for authors in the Yoast SEO plugin settings',
						'Changed the setting <strong>Security: advanced or schema settings for authors</strong> in the plugin.',
						'yoast-seo',
						'enabled',
					),
					array(
						8826,
						WSAL_LOW,
						'User Enabled/Disabled redirecting attachment URLs in the Yoast SEO plugin settings',
						'Changed the status of the setting <strong>Redirect attachment URLs</strong> in the <strong>Media</strong> search appearance settings.',
						'yoast-seo',
						'enabled',
					),
					array(
						8827,
						WSAL_MEDIUM,
						'User Enabled/Disabled Usage tracking in the Yoast SEO plugin settings',
						'Changed the status of the <strong>Usage tracking</strong> plugin setting.',
						'yoast-seo',
						'enabled',
					),
					array(
						8828,
						WSAL_MEDIUM,
						'User Enabled/Disabled REST API: Head endpoint in the Yoast SEO plugin settings',
						'Changed the status of the <strong>REST API: Head endpoint</strong> plugin setting.',
						'yoast-seo',
						'enabled',
					),
					array(
						8829,
						WSAL_LOW,
						'User Added/Removed a social profile in the Yoast SEO plugin settings',
						'Changed the URL of an <strong>Organization social profile</strong>. %LineBreak% Social media profile: %social_profile% %LineBreak% Old URL: %old_url% %LineBreak% New URL: %new_url%',
						'yoast-seo',
						'added',
					),
					array(
						8838,
						WSAL_HIGH,
						'User changed who should have access to the setting on Network Level',
						'Changed the setting <strong>Who should have access to the Yoast SEO settings</strong> on a multisite network to %new%. %LineBreak% Previous setting: %old%',
						'yoast-seo',
						'enabled',
					),
					array(
						8839,
						WSAL_LOW,
						'New sites inherit their SEO options from site changed',
						'Changed the setting <strong>New sites in the network inherit their SEO settings from this site</strong> to %new%. %LineBreak% Previous setting: %old%',
						'yoast-seo',
						'enabled',
					),
					array(
						8840,
						WSAL_MEDIUM,
						'Reset the site\'s SEO settings to default',
						'Reset the SEO settings of the site %old% to default. %LineBreak% Site ID: %old%',
						'yoast-seo',
						'enabled',
					),
					array(
						8842,
						WSAL_HIGH,
						'Disabled a plugin feature networkwide',
						'Disabled the plugin feature %feature_name% networkwide.',
						'yoast-seo',
						'disabled',
					),
					array(
						8843,
						WSAL_HIGH,
						'Allowed site administrators to toggle a plugin feature on or off for their site',
						'Allowed site administrators to toggle the plugin feature %feature_name% on or off on their sites.',
						'yoast-seo',
						'enabled',
					),
					array(
						8813,
						WSAL_MEDIUM,
						'User Enabled/Disabled the option Show Posts/Pages in Search Results in the Yoast SEO plugin settings',
						'Changed the status of the content type setting to show %SEOPostType% in search results.',
						'yoast-seo',
						'enabled',
					),
					array(
						8814,
						WSAL_INFORMATIONAL,
						'User changed the Posts/Pages title template in the Yoast SEO plugin settings',
						'Changed the %SEOPostType% SEO title template in the plugin settings to %new%. %LineBreak% Previous template: %old%',
						'yoast-seo',
						'modified',
					),
					array(
						8830,
						WSAL_MEDIUM,
						'User Enabled/Disabled the taxonomies to show in search results setting in the Yoast SEO plugin settings',
						'Changed the status of the taxonomies setting to show %SEOPostType% in search results.',
						'yoast-seo',
						'enabled',
					),
					array(
						8831,
						WSAL_LOW,
						'User Modified the SEO title template for a taxonomy in the Yoast SEO plugin settings',
						'Changed the SEO title template for the taxonomy %SEOPostType% to %new%. %LineBreak% Previous title: %old%',
						'yoast-seo',
						'modified',
					),
					array(
						8832,
						WSAL_LOW,
						'User Modified the Meta description template for a taxonomy in the Yoast SEO plugin settings',
						'Changed the Meta description template for the taxonomy %SEOPostType% to %new%. %LineBreak% Previous description: %old%',
						'yoast-seo',
						'modified',
					),
					array(
						8833,
						WSAL_MEDIUM,
						'User Enabled/Disabled Author or Data archives in Yoast SEO plugin settings',
						'Changed the status of the %archive_type% archives in the plugin settings.',
						'yoast-seo',
						'enabled',
					),
					array(
						8834,
						WSAL_MEDIUM,
						'User Enabled/Disabled showing Author or Date archives in search results in Yoast SEO plugin settings',
						'Changed the status of the setting to show the %archive_type% archives in the search results.',
						'yoast-seo',
						'enabled',
					),
					array(
						8835,
						WSAL_LOW,
						'User Modified the SEO title template for Author or Date archives in the Yoast SEO plugin settings',
						'Changed the SEO title template for the %archive_type% archives to %new%. %LineBreak% Previous title: %old%',
						'yoast-seo',
						'modified',
					),
					array(
						8836,
						WSAL_LOW,
						'User Modified the SEO Meta description for Author or Date archives in the Yoast SEO plugin settings',
						'Changed the Meta description template for the %archive_type% archives to %new%. %LineBreak% Previous description: %old%',
						'yoast-seo',
						'modified',
					),
					array(
						8837,
						WSAL_LOW,
						'User Enabled/Disabled the SEO meta box for a taxonomy',
						'Changed the status of the setting to show SEO settings for the %SEOPostType% taxonomy.',
						'yoast-seo',
						'enabled',
					),
					array(
						8841,
						WSAL_MEDIUM,
						'User Added/Removed/Modified a Webmaster Tools verification code for a search engine',
						'Changed the <strong>Webmaster Tools verification code</strong> for a search engine. %LineBreak% Search engine: %search_engine_type% %LineBreak% Previous code: %old% %LineBreak% New code: %new%',
						'yoast-seo',
						'added',
					),
					array(
						8844,
						WSAL_MEDIUM,
						'Changed the status of the setting Add Open Graph meta data in the Facebook settings',
						'Changed the status of the setting <strong>Add Open Graph meta data</strong> in the <strong>Facebook settings.</strong>',
						'yoast-seo',
						'disabled',
					),
					array(
						8845,
						WSAL_MEDIUM,
						'Changed the Default Image in the Facebook settings',
						'Changed the <strong>Default Image</strong> in the Facebook settings to <strong>%image_name%</strong>. %LineBreak% Image path: %image_path% %LineBreak% Previous image: %old_image% %LineBreak% Previous image path: %old_path%',
						'yoast-seo',
						'modified',
					),
					array(
						8846,
						WSAL_MEDIUM,
						'Changed the status of the setting Add Twitter card meta data in the Twitter settings',
						'Changed the status of the setting <strong>Add Twitter card meta data</strong> in the <strong>Twitter settings.</strong>',
						'yoast-seo',
						'disabled',
					),
					array(
						8847,
						WSAL_MEDIUM,
						'Changed the Default card type to use in Twitter settings',
						'Changed the <strong>Default card type to use</strong> in Twitter settings to <strong>%new_setting%.</strong> %LineBreak% Previous setting: %old_setting%',
						'yoast-seo',
						'modified',
					),
					array(
						8848,
						WSAL_MEDIUM,
						'Changed the Pinterest confirmation meta tag in the Pinterest settings',
						'Changed the Pinterest confirmation meta tag in the Pinterest settings to %new_value%. %LineBreak% Previous value: %old_value%',
						'yoast-seo',
						'modified',
					),
				),
			),
			'File Changes'                   => array(
				'Monitor File Changes' => array(
					array(
						6028,
						WSAL_HIGH,
						'File content has been modified',
						'Content of file(s) on this website modified. %ReviewChangesLink%',
						'file',
						'modified',
					),
					array(
						6029,
						WSAL_CRITICAL,
						'File added to the site',
						'New file(s) added on this website. %ReviewAdditionsLink%',
						'file',
						'added',
					),
					array(
						6030,
						WSAL_MEDIUM,
						'File deleted from the site',
						'File(s) deleted from this website. %ReviewDeletionsLink%',
						'file',
						'deleted',
					),
					array(
						6031,
						WSAL_INFORMATIONAL,
						'File not scanned because it is bigger than the maximum file size limit',
						'File not scanned because it is bigger than the maximum file size limit %LineBreak% File: %File% %LineBreak% Location: %FileLocation% %LineBreak% %ReviewChangesLink%',
						'system',
						'blocked',
					),
					array(
						6032,
						WSAL_INFORMATIONAL,
						'File integrity scan stopped due to the limit of 200,000 files',
						'Your website has more than 200,000 files so the file integrity scanner cannot scan them all. Contact support for more information. %LineBreak% %ContactSupport%',
						'system',
						'blocked',
					),
					array(
						6033,
						WSAL_INFORMATIONAL,
						'File integrity scan started/stopped',
						'The file integrity scan has %ScanStatus%.',
						'system',
						'started',
					),
					array(
						99999,
						WSAL_HIGH,
						'Dummy',
						'',
						'file',
						'modified',
					),
				),
			),
			'Gravity Forms'                  => array(
				'Monitor Gravity Forms' => array(
					array(
						5700,
						WSAL_LOW,
						'A form was created, modified',
						'The Form called %form_name%. %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'gravityforms_forms',
						'created',
					),
					array(
						5701,
						WSAL_MEDIUM,
						'A form was moved to trash',
						'Moved the form to trash. %LineBreak% Form name: %form_name% %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'gravityforms_forms',
						'created',
					),
					array(
						5702,
						WSAL_MEDIUM,
						'A form was permanently deleted',
						'Permanently deleted the form %form_name%. %LineBreak% Form ID: %form_id%',
						'gravityforms_forms',
						'created',
					),
					array(
						5703,
						WSAL_MEDIUM,
						'A form setting was modified',
						'The setting %setting_name% in form %form_name%. %LineBreak% Previous value: %old_setting_value% %LineBreak% New value: %setting_value% %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'gravityforms_forms',
						'modified',
					),
					array(
						5704,
						WSAL_LOW,
						'A form was duplicated',
						'Duplicated the form %original_form_name%. %LineBreak% New form name: %new_form_name% %LineBreak% Source form ID: %original_form_id% %LineBreak% New form ID: %new_form_id% %LineBreak% View new duplicated form in the editor: %EditorLinkForm%',
						'gravityforms_forms',
						'duplicated',
					),
					array(
						5715,
						WSAL_MEDIUM,
						'A field was created, modified or deleted',
						'The Field called %field_name% in the form %form_name%. %LineBreak% Field type: %field_type% %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'gravityforms_fields',
						'created',
					),
					array(
						5709,
						WSAL_LOW,
						'A form was submitted',
						'Submitted the form %form_name%. %LineBreak% Form ID: %form_id% %LineBreak% Submission email: %email% %LineBreak% View entry: %EntryLink%',
						'gravityforms_forms',
						'duplicated',
					),
					array(
						5705,
						WSAL_MEDIUM,
						'A confirmation was created, modified or deleted',
						'The Confirmation called %confirmation_name% in the form %form_name%. %LineBreak% Confirmation type: %confirmation_type% %LineBreak% Confirmation message: %confirmation_message% %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'gravityforms_confirmations',
						'created',
					),
					array(
						5708,
						WSAL_LOW,
						'A confirmation was activated or deactivated',
						'The confirmation %confirmation_name% in the form %form_name%. %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'gravityforms_confirmations',
						'created',
					),
					array(
						5706,
						WSAL_MEDIUM,
						'A notification was created, modified or deleted',
						'The Notification called %notification_name% in the form %form_name%. %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'gravityforms_notifications',
						'created',
					),
					array(
						5707,
						WSAL_LOW,
						'A notification was activated or deactivated',
						'Changed the status of the Notification called %notification_name% in the form %form_name%. %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'gravityforms_notifications',
						'activated',
					),
					array(
						5710,
						WSAL_LOW,
						'An entry was starred or unstarred',
						'Entry title: %entry_title%. %LineBreak% Form name: %form_name% %LineBreak% Form ID: %form_id% %LineBreak% View entry: %EntryLink%',
						'gravityforms_entries',
						'starred',
					),
					array(
						5711,
						WSAL_LOW,
						'An entry was marked as read or unread',
						'The entry called %entry_title% from form %form_name%. %LineBreak% Form ID: %form_id% %LineBreak% View entry: %EntryLink%',
						'gravityforms_entries',
						'read',
					),
					array(
						5712,
						WSAL_MEDIUM,
						'An entry was moved to trash',
						'Deleted the entry %event_desc%. %LineBreak% Form name: %form_name% %LineBreak% Form ID : %form_id% %LineBreak% View entry: %EntryLink%',
						'gravityforms_entries',
						'read',
					),
					array(
						5713,
						WSAL_MEDIUM,
						'An entry was permanently deleted',
						'Permanently deleted the entry %entry_title%. %LineBreak% Form name: %form_name% %LineBreak% Form ID: %form_id%',
						'gravityforms_entries',
						'read',
					),
					array(
						5714,
						WSAL_MEDIUM,
						'An entry note was created or deleted',
						'The entry note %entry_note%. %LineBreak% Entry title: %entry_title% %LineBreak% Form name: %form_name% %LineBreak% Form ID: %form_id% %LineBreak% View entry: %EntryLink%',
						'gravityforms_entries',
						'read',
					),
					array(
						5716,
						WSAL_HIGH,
						'A plugin setting was changed.',
						'Changed the plugin setting %setting_name%. %LineBreak% Previous value: %old_value% %LineBreak% New value: %new_value%',
						'gravityforms_settings',
						'modified',
					),
				),
			),
			'TablePress'                     => array(
				'Monitor TablePress' => array(
					array(
						8900,
						WSAL_MEDIUM,
						'A table was created',
						'Added the new table %table_name%. %LineBreak% Table ID: %table_id% %LineBreak% Number of rows: %rows% %LineBreak% Number of columns: %columns% %LineBreak% View in the editor: %EditorLink%',
						'tablepress_tables',
						'added',
					),
					array(
						8901,
						WSAL_HIGH,
						'A table was deleted',
						'Deleted the table %table_name%. %LineBreak% Table ID: %table_id%',
						'tablepress_tables',
						'deleted',
					),
					array(
						8902,
						WSAL_MEDIUM,
						'A table was duplicated',
						'Created a copy of the table %table_name%. %LineBreak% New table name: %new_table_name% %LineBreak% New table ID: %table_id% %LineBreak% View in the editor: %EditorLink%',
						'tablepress_tables',
						'added',
					),
					array(
						8903,
						WSAL_MEDIUM,
						'A table was imported',
						'Imported the table %table_name%. %LineBreak% Table ID: %table_id% %LineBreak% View in the editor: %EditorLink%',
						'tablepress_tables',
						'imported',
					),
					array(
						8904,
						WSAL_MEDIUM,
						'A table ID was changed',
						'Changed the ID of the table %table_name%. %LineBreak% Previous table ID: %old_table_id% %LineBreak% New table ID: %table_id% %LineBreak% View in the editor: %EditorLink%',
						'tablepress_tables',
						'updated',
					),
					array(
						8905,
						WSAL_MEDIUM,
						'A table was modified',
						'Made changes to the table %table_name% %LineBreak% Table ID: %table_id% %LineBreak% Number of rows: %rows% %LineBreak% Number of columns: %columns% %LineBreak% Previous number of rows: %old_rows% %LineBreak% Previous number of columns: %old_columns% %LineBreak% View in the editor: %EditorLink%',
						'tablepress_tables',
						'updated',
					),
					array(
						8906,
						WSAL_MEDIUM,
						'A table row was added or removed',
						'A row was added or removed from the table %table_name% %LineBreak% Table ID: %table_id% %LineBreak% Previous row count: %old_count% %LineBreak% New row count: %count% %LineBreak% View in the editor: %EditorLink%',
						'tablepress_tables',
						'added',
					),
					array(
						8907,
						WSAL_MEDIUM,
						'A table column was added or removed',
						'A column was added or removed from the table %table_name% %LineBreak% Table ID: %table_id% %LineBreak% Previous column count: %old_count% %LineBreak% New column count: %count% %LineBreak% View in the editor: %EditorLink%',
						'tablepress_tables',
						'added',
					),
					array(
						8908,
						WSAL_MEDIUM,
						'A table option was modified',
						'Changed the status of the table option %option_name% in %table_name% %LineBreak% Table ID: %table_id% %LineBreak% Previous value: %old_value% %LineBreak% New value: %new_value% %LineBreak% View in the editor: %EditorLink%',
						'tablepress_tables',
						'modified',
					),
				),
			),
			'WooCommerce'                    => array(
				'Products'         => array(
					array(
						9000,
						WSAL_LOW,
						'User created a new product',
						'Created a new product called %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'created',
					),
					array(
						9001,
						WSAL_MEDIUM,
						'User published a product',
						'Published the product called %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'published',
					),
					array(
						9003,
						WSAL_LOW,
						'User changed the category of a product',
						'Changed the category(ies) of the product %ProductTitle% to %NewCategories%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous categories: %OldCategories% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9004,
						WSAL_INFORMATIONAL,
						'User modified the short description of a product',
						'Changed the short description of the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9005,
						WSAL_LOW,
						'User modified the text of a product',
						'Changed the text of the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9006,
						WSAL_LOW,
						'User changed the URL of a product',
						'Changed the URL of the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous URL: %OldUrl% %LineBreak% New URL: %NewUrl% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9007,
						WSAL_MEDIUM,
						'User changed the Product Data of a product',
						'Changed the type of the product %ProductTitle% to %NewType%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous type: %OldType% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9008,
						WSAL_INFORMATIONAL,
						'User changed the date of a product',
						'Changed the date of the product %ProductTitle% to %NewDate%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous date: %OldDate% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9009,
						WSAL_MEDIUM,
						'User changed the visibility of a product',
						'Changed the visibility of the product %ProductTitle% to %NewVisibility%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous visibility: %OldVisibility% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9010,
						WSAL_MEDIUM,
						'User modified the product',
						'Modified the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9011,
						E_NOTICE,
						'User modified the draft product',
						'Modified the draft product %ProductTitle%. %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'',
					),
					array(
						9012,
						WSAL_HIGH,
						'User moved a product to trash',
						'Moved the product %ProductTitle% to trash. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus%',
						'woocommerce-product',
						'deleted',
					),
					array(
						9013,
						WSAL_MEDIUM,
						'User permanently deleted a product',
						'Permanently deleted the product %ProductTitle%. %LineBreak% Product ID: %PostID%',
						'woocommerce-product',
						'deleted',
					),
					array(
						9014,
						WSAL_HIGH,
						'User restored a product from the trash',
						'Restored the product %ProductTitle% from trash. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'restored',
					),
					array(
						9015,
						WSAL_MEDIUM,
						'User changed status of a product',
						'Changed the status of the product %ProductTitle% to %NewStatus%. %LineBreak% Product ID: %PostID% %LineBreak% Previous status: %OldStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9072,
						WSAL_INFORMATIONAL,
						'User opened a product in the editor',
						'Opened the product %ProductTitle% in the editor. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'opened',
					),
					array(
						9073,
						WSAL_INFORMATIONAL,
						'User viewed a product',
						'Viewed the product %ProductTitle% page. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'viewed',
					),
					array(
						9077,
						WSAL_MEDIUM,
						'User renamed a product',
						'Renamed the product %OldTitle% to %NewTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'renamed',
					),
					array(
						9016,
						WSAL_MEDIUM,
						'User changed type of a price',
						'Changed the %PriceType% price of the product %ProductTitle% to %NewPrice%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous price: %OldPrice% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9017,
						WSAL_MEDIUM,
						'User changed the SKU of a product',
						'Changed the SKU of the product %ProductTitle% to %NewSku%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous SKU: %OldSku% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9018,
						WSAL_LOW,
						'User changed the stock status of a product',
						'Changed the stock status of the product %ProductTitle% to %NewStatus%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous stock status: %OldStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9020,
						WSAL_MEDIUM,
						'User set a product type',
						'Changed the type of the product %ProductTitle% to %NewType%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous type: %OldType% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9021,
						WSAL_INFORMATIONAL,
						'User changed the weight of a product',
						'Changed the weight of the product %ProductTitle% to %NewWeight%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous weight: %OldWeight% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9022,
						WSAL_INFORMATIONAL,
						'User changed the dimensions of a product',
						'Changed the %DimensionType% dimensions of the product %ProductTitle% to %NewDimension%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous value: %OldDimension% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9023,
						WSAL_MEDIUM,
						'User added the Downloadable File to a product',
						'Added the downloadable file %FileName% to the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% File URL: %FileUrl% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9024,
						WSAL_MEDIUM,
						'User Removed the Downloadable File from a product',
						'Removed the downloadable file %FileName% from the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% File URL: %FileUrl% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9025,
						WSAL_INFORMATIONAL,
						'User changed the name of a Downloadable File in a product',
						'Changed the name of the downloadable file %OldName% to %NewName% in the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous file name: %OldName% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9026,
						WSAL_MEDIUM,
						'User changed the URL of the Downloadable File in a product',
						'Changed the URL of the downloadable file to the product %ProductTitle% %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% File name: %FileName% %LineBreak% Previous URL: %OldUrl% %LineBreak% New URL: %NewUrl% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9042,
						WSAL_INFORMATIONAL,
						'User changed the catalog visibility of a product',
						'Changed the product visibility of the product %ProductTitle% to %NewVisibility%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous visibility setting: %OldVisibility% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9043,
						WSAL_INFORMATIONAL,
						'User changed the setting Featured Product of a product',
						'Changed the status of the setting <strong>Featured Product</strong> for the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'enabled',
					),
					array(
						9044,
						WSAL_INFORMATIONAL,
						'User changed the Allow Backorders setting of a product',
						'Changed the Allow Backorders setting for the product %ProductTitle% to %NewStatus%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous status: %OldStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9045,
						WSAL_MEDIUM,
						'User added/removed products to upsell of a product',
						'Products to the Upsell setting in product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% New product in Upsells: %UpsellTitle% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'added',
					),
					array(
						9046,
						WSAL_MEDIUM,
						'User added/removed products to cross-sells of a product',
						'Products to the Cross-sell setting in product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% New product in Cross-sells: %CrossSellTitle% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'added',
					),
					array(
						9095,
						WSAL_LOW,
						'Added or deleted a product image',
						'The product image of the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Image name: %name% %LineBreak% Image path: %path% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'added',
					),
					array(
						9096,
						WSAL_LOW,
						'Modified a product image',
						'Changed the product image of the product %ProductTitle%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous image name: %old_name% %LineBreak% Previous image path: %old_path% %LineBreak% New image name: %name% %LineBreak% New image path: %path% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9097,
						WSAL_LOW,
						'Modified the download limit of the product',
						'Changed the download limit of the product %product_name% to %new_value%. %LineBreak% Product ID: %ID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous value: %previous_value% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9098,
						WSAL_LOW,
						'Modified the download expiry setting of the product',
						'Changed the download expire setting of the product %product_name% to %new_value%. %LineBreak% Product ID: %ID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous value: %previous_value% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9099,
						WSAL_LOW,
						'A product was downloaded',
						'Downloaded the product %product_name%. %LineBreak% Product ID: %ID% %LineBreak% User email: %email_address%',
						'woocommerce-product',
						'modified',
					),
					array(
						9105,
						WSAL_LOW,
						'System changed the stock quantity of a product',
						'The stock quantity of the product %ProductTitle% was changed to %NewValue% due to a purchase. %LineBreak% Product ID: %PostID% %LineBreak% User name: %Username% %LineBreak% Order name: %StockOrderID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous quantity: %OldValue% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9106,
						WSAL_LOW,
						'Third-party plugin changed the stock quantity of a product',
						'The stock quantity of the product %ProductTitle% was changed to %NewValue% via third party system. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous quantity: %OldValue% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9113,
						WSAL_MEDIUM,
						'The Tax status of a product has been modified',
						'Changed the Tax status of the product %ProductTitle% to %new_tax_status%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous tax status: %old_tax_status% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9114,
						WSAL_MEDIUM,
						'The Tax class of a product has been modified',
						'Changed the Tax class of the product %ProductTitle% to %new_tax_class%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous tax class: %old_tax_class% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9019,
						WSAL_LOW,
						'User changed the stock quantity',
						'Changed the stock quantity of the product %ProductTitle% to %NewValue%. %LineBreak% Product ID: %PostID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous quantity: %OldValue% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9047,
						WSAL_LOW,
						'Added a new attribute of a product',
						'Added a new attribute caled %AttributeName% to the product %ProductTitle%. %LineBreak% Product ID: %ProductID% %LineBreak% Product status: %ProductStatus% %LineBreak% Attribute value: %AttributeValue% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'added',
					),
					array(
						9048,
						WSAL_LOW,
						'Modified the value of an attribute of a product',
						'Modified the value of the attribute %AttributeName$ in the product %ProductTitle%. %LineBreak% Product ID: %ProductID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous attribute value: %OldValue% %LineBreak% New attribute value: %NewValue% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
					array(
						9049,
						WSAL_LOW,
						'Changed the name of an attribute of a product',
						'Renamed the attribute %OldValue% to %NewValue% in the product %ProductTitle%. %LineBreak% Product ID: %ProductID% %LineBreak% Product status: %ProductStatus% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'renamed',
					),
					array(
						9050,
						WSAL_LOW,
						'Deleted an attribute of a product',
						'Deleted the attribute %AttributeName% from the product %ProductTitle%. %LineBreak% Product ID: %ProductID% %LineBreak% Product status: %ProductStatus% %LineBreak% Attribute value: %AttributeValue% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'deleted',
					),
					array(
						9051,
						WSAL_LOW,
						'Set the attribute visibility of a product',
						'Changed the visibility of the attribute %AttributeName% to %AttributeVisiblilty% in the the product %ProductTitle%. %LineBreak% Product ID: %ProductID% %LineBreak% Product status: %ProductStatus% %LineBreak% Previous visibility: %OldAttributeVisiblilty% %LineBreak% View product in editor: %EditorLinkProduct%',
						'woocommerce-product',
						'modified',
					),
				),
				'Store'            => array(
					array(
						9027,
						WSAL_HIGH,
						'User changed the Weight Unit',
						'Changed the <strong>weight unit</strong> of the store to %NewUnit%. %LineBreak% Previous weight unit: %OldUnit%',
						'woocommerce-store',
						'modified',
					),
					array(
						9028,
						WSAL_HIGH,
						'User changed the Dimensions Unit',
						'Changed the <strong>dimensions unit</strong> of the store to %NewUnit%. %LineBreak% Previous dimensions unit: %OldUnit%',
						'woocommerce-store',
						'modified',
					),
					array(
						9029,
						WSAL_HIGH,
						'User changed the Base Location',
						'Changed the <strong>base location</strong> of the store to %NewLocation%. %LineBreak% Previous address: %OldLocation%',
						'woocommerce-store',
						'modified',
					),
					array(
						9030,
						WSAL_HIGH,
						'User enabled/disabled taxes',
						'Changed the status of the <strong>Taxes</strong> store setting.',
						'woocommerce-store',
						'enabled',
					),
					array(
						9031,
						WSAL_HIGH,
						'User changed the currency',
						'Changed the <strong>currency</strong> of the store to %NewCurrency%. %LineBreak% Previous currency: %OldCurrency%',
						'woocommerce-store',
						'modified',
					),
					array(
						9032,
						WSAL_HIGH,
						'User enabled/disabled the use of coupons during checkout',
						'Changed the status of the store setting <strong>use of coupons during checkout</strong>.',
						'woocommerce-store',
						'enabled',
					),
					array(
						9033,
						WSAL_MEDIUM,
						'User enabled/disabled guest checkout',
						'Changed the status of the store setting <strong>Guest checkout</strong>.',
						'woocommerce-store',
						'enabled',
					),
					array(
						9034,
						WSAL_HIGH,
						'User enabled/disabled Cash on delivery',
						'Changed the status of the store setting <strong>cash on delivery</strong>',
						'woocommerce-store',
						'enabled',
					),
					array(
						9085,
						WSAL_HIGH,
						'User modified selling location(s)',
						'Changed the store setting <strong>Selling location(s)</strong> to %new%. %LineBreak% Previous setting: %old%',
						'woocommerce-store',
						'modified',
					),
					array(
						9086,
						WSAL_HIGH,
						'User modified excluded selling location(s)',
						'Changed the <strong>list of excluded countries to sell to</strong> setting in the store. %LineBreak% Previous list of countries: %old% %LineBreak% New list of countries: %new%',
						'woocommerce-store',
						'modified',
					),
					array(
						9087,
						WSAL_HIGH,
						'User modified exclusive selling location(s)',
						'Changed the <strong>list of countries to sell to</strong> setting in the store. %LineBreak% Previous list of countries: %old% %LineBreak% New list of countries: %new%',
						'woocommerce-store',
						'modified',
					),
					array(
						9088,
						WSAL_HIGH,
						'User modified shipping location(s)',
						'Changed the <strong>Shipping location(s)</strong> setting in the store. %LineBreak% Previous setting: %old% %LineBreak% New Setting: %new%',
						'woocommerce-store',
						'modified',
					),
					array(
						9089,
						WSAL_HIGH,
						'User modified exclusive shipping location(s)',
						'Changed the <strong>List of specific countries to</strong> ship to setting in the store. %LineBreak% Previous list of countries: %old% %LineBreak% New list of countries: %new%',
						'woocommerce-store',
						'modified',
					),
					array(
						9090,
						WSAL_HIGH,
						'User modified default customer location',
						'Changed the <strong>Default customer location</strong> setting to %new%. %LineBreak% Previous location: %old%',
						'woocommerce-store',
						'modified',
					),
					array(
						9091,
						WSAL_HIGH,
						'User modified the cart page',
						'Changed the store\'s <strong>Cart page</strong> to %new%. %LineBreak% Previous page: %old%',
						'woocommerce-store',
						'modified',
					),
					array(
						9092,
						WSAL_HIGH,
						'User modified the checkout page',
						'Changed the store\'s <strong>Checkout page</strong> to %new%. %LineBreak% Previous page: %old%',
						'woocommerce-store',
						'modified',
					),
					array(
						9093,
						WSAL_HIGH,
						'User modified the my account page',
						'Changed the store\'s <strong>My account page</strong> to %new%. %LineBreak% Previous page: %old%',
						'woocommerce-store',
						'modified',
					),
					array(
						9094,
						WSAL_HIGH,
						'User modified the terms and conditions page',
						'Changed the store\'s <strong>Terms and conditions page</strong> to %new%. %LineBreak% Previous page: %old%',
						'woocommerce-store',
						'modified',
					),
					array(
						9100,
						WSAL_MEDIUM,
						'Changed the status of the Enable product reviews setting in the store',
						'Changed the status of the <strong>Enable product reviews</strong> setting in the store.',
						'woocommerce-store',
						'modified',
					),
					array(
						9107,
						WSAL_LOW,
						'Changed the status of the Show \"verified owner\" label on customer reviews setting in the store',
						'Changed the status of the <strong>Show \"verified owner\" label on customer reviews</strong> setting in the store.',
						'woocommerce-store',
						'modified',
					),
					array(
						9108,
						WSAL_LOW,
						'Changed the status of the Reviews can only be left by \"verified owners\" setting in the store',
						'Changed the status of the <strong>Reviews can only be left by \"verified owners\"</strong> setting in the store.',
						'woocommerce-store',
						'modified',
					),
					array(
						9109,
						WSAL_MEDIUM,
						'Changed the status of the Star rating on reviews setting in the store',
						'Changed the status of the <strong>Star rating on reviews</strong> setting in the store.',
						'woocommerce-store',
						'modified',
					),
					array(
						9110,
						WSAL_MEDIUM,
						'Changed the status of the Star ratings should be required setting in the store',
						'Changed the status of the <strong>Star ratings should be required</strong> setting in the store.',
						'woocommerce-store',
						'modified',
					),
					array(
						9111,
						WSAL_MEDIUM,
						'A Checkout endpoint has been modified',
						'Changed the <strong>Checkout endpoint</strong> %endpoint_name% to %new_value%. %LineBreak% Previous endpoint value: %old%',
						'woocommerce-store',
						'modified',
					),
					array(
						9112,
						WSAL_MEDIUM,
						'An Account endpoint has been modified',
						'Changed the <strong>Account endpoint</strong> %endpoint_name% to %new_value%. %LineBreak% Previous endpoint value: %old%',
						'woocommerce-store',
						'modified',
					),
				),
				'Payment Gateways' => array(
					array(
						9074,
						WSAL_HIGH,
						'User enabled/disabled a payment gateway',
						'Changed the status of the payment gateway %GatewayName%.',
						'woocommerce-store',
						'enabled',
					),
					array(
						9075,
						E_CRITICAL,
						'User disabled a payment gateway',
						'User disabled a payment gateway %LineBreak% The payment gateway: %GatewayName%',
						'woocommerce-store',
						'',
					),
					array(
						9076,
						WSAL_HIGH,
						'User modified a payment gateway',
						'Changed the settings of the %GatewayName% payment gateway.',
						'woocommerce-store',
						'modified',
					),
				),
				'Tax Settings'     => array(
					array(
						9078,
						WSAL_LOW,
						'User modified prices with tax option',
						'Changed the store setting <strong>Prices entered with tax</strong> to %TaxStatus% taxes.',
						'woocommerce-store',
						'modified',
					),
					array(
						9079,
						WSAL_LOW,
						'User modified tax calculation base',
						'Changed the store setting <strong>Calculate tax based on</strong> to %Setting%',
						'woocommerce-store',
						'modified',
					),
					array(
						9080,
						WSAL_MEDIUM,
						'User modified shipping tax class',
						'Changed the store setting <strong>Shipping tax class</strong> to %Setting%',
						'woocommerce-store',
						'modified',
					),
					array(
						9081,
						WSAL_MEDIUM,
						'User enabled/disabled rounding of tax',
						'Changed the status of the store tax setting <strong>Rounding</strong> of tax at subtotal level.',
						'woocommerce-store',
						'enabled',
					),
					array(
						9082,
						WSAL_MEDIUM,
						'User modified a shipping zone',
						'The shipping zone %ShippingZoneName% on the WooCommerce store',
						'woocommerce-store',
						'created',
					),
				),
				'WC Categories'    => array(
					array(
						9002,
						WSAL_INFORMATIONAL,
						'User created a new product category',
						'Created new product category called %CategoryName%. %LineBreak% Category slug: %Slug% %LineBreak% View category: %ProductCatLink%',
						'woocommerce-category',
						'created',
					),
					array(
						9052,
						WSAL_MEDIUM,
						'User deleted a product category',
						'Deleted the product category called %CategoryName%. %LineBreak% Category slug: %CategorySlug%',
						'woocommerce-category',
						'deleted',
					),
					array(
						9053,
						WSAL_INFORMATIONAL,
						'User changed the slug of a product category',
						'Changed the slug of the product category called %CategoryName%. %LineBreak% Previous category slug: %OldSlug% %LineBreak% New category slug: %NewSlug% %LineBreak% View category: %ProductCatLink%',
						'woocommerce-category',
						'modified',
					),
					array(
						9054,
						WSAL_MEDIUM,
						'User changed the parent category of a product category',
						'Changed the parent of the product category %CategoryName% to %NewParentCat%. %LineBreak% Category slug: %CategorySlug% %LineBreak% Previous parent: %OldParentCat% %LineBreak% View category: %ProductCatLink%',
						'woocommerce-category',
						'modified',
					),
					array(
						9055,
						WSAL_INFORMATIONAL,
						'User changed the display type of a product category',
						'Changed the display type of the product category %name% to %NewDisplayType%. %LineBreak% Category slug: %CategorySlug% %LineBreak% Previous display type: %OldDisplayType% %LineBreak% View category: %ProductCatLink%',
						'woocommerce-category',
						'modified',
					),
					array(
						9056,
						WSAL_LOW,
						'User changed the name of a product category',
						'Renamed the product category %OldName% to %NewName%. %LineBreak% Previous category name: %OldName% %LineBreak% Category slug: %CategorySlug% %LineBreak% View category: %ProductCatLink%',
						'woocommerce-category',
						'renamed',
					),
				),
				'WC Tags'          => array(
					array(
						9101,
						WSAL_INFORMATIONAL,
						'User created a new product tag',
						'Created the tag %CategoryName%. %LineBreak% Slug: %Slug% %LineBreak% View product tag: %ProductTagLink%',
						'woocommerce-tag',
						'created',
					),
					array(
						9102,
						WSAL_INFORMATIONAL,
						'User deleted a product tag',
						'Deleted the tag %Name%. %LineBreak% Slug: %Slug%',
						'woocommerce-tag',
						'deleted',
					),
					array(
						9103,
						WSAL_INFORMATIONAL,
						'User renamed product tag',
						'Renamed the tag %OldName% to %NewName%. %LineBreak% Slug: %Slug% %LineBreak% View product tag: %ProductTagLink%',
						'woocommerce-tag',
						'renamed',
					),
					array(
						9104,
						WSAL_INFORMATIONAL,
						'User changed product tag slug',
						'Changed the slug of the tag %TagName% to %NewSlug%. %LineBreak% Previous slug: %OldSlug% %LineBreak% View product tag: %ProductTagLink%',
						'woocommerce-tag',
						'modified',
					),
				),
				'Attributes'       => array(
					array(
						9057,
						WSAL_MEDIUM,
						'User created a new attribute',
						'Created a new attribute in WooCommerce called %AttributeName%. %LineBreak% Attribute slug: %AttributeSlug%',
						'woocommerce-store',
						'created',
					),
					array(
						9058,
						WSAL_LOW,
						'User deleted an attribute',
						'Deleted the WooCommerce attribute %AttributeName%. %LineBreak% Attribute slug: %AttributeSlug%',
						'woocommerce-store',
						'deleted',
					),
					array(
						9059,
						WSAL_LOW,
						'User changed the slug of an attribute',
						'Changed the slug of the WooCommerce attribute %AttributeName% to %NewSlug%. %LineBreak% Previous slug: %OldSlug%',
						'woocommerce-store',
						'modified',
					),
					array(
						9060,
						WSAL_LOW,
						'User changed the name of an attribute',
						'Renamed the WooCommerce attribute %AttributeName% to %NewName%. %LineBreak% Attribute slug: %AttributeSlug% %LineBreak% Previous name: %OldName%',
						'woocommerce-store',
						'modified',
					),
					array(
						9061,
						WSAL_LOW,
						'User changed the default sort order of an attribute',
						'Changed the Default Sorting Order of the attribute %AttributeName% in WooCommerce to %NewSortOrder%. %LineBreak% Attribute slug: %AttributeSlug% %LineBreak% Previous sorting order: %OldSortOrder%',
						'woocommerce-store',
						'modified',
					),
					array(
						9062,
						WSAL_LOW,
						'User enabled/disabled the option Enable Archives of an attribute',
						'Changed the status of the option Enable Archives in WooCommerce attribute %AttributeName%. %LineBreak% Attribute slug: %Slug%',
						'woocommerce-store',
						'enabled',
					),
				),
				'Coupons'          => array(
					array(
						9063,
						WSAL_LOW,
						'User published a new coupon',
						'Created the WooCommerce coupon: %CouponName%. %LineBreak% View coupon in editor: %EditorLinkCoupon%',
						'woocommerce-coupon',
						'published',
					),
					array(
						9064,
						WSAL_LOW,
						'User changed the discount type of a coupon',
						'Changed the Discount Type in the coupon %CouponName% to %NewDiscountType%.% %LineBreak% Previous discount type: %OldDiscountType% %LineBreak% %EditorLinkCoupon%',
						'woocommerce-coupon',
						'modified',
					),
					array(
						9065,
						WSAL_LOW,
						'User changed the coupon amount of a coupon',
						'Changed the Coupon amount in the coupon %CouponName% to %NewAmount%. %LineBreak% Previous amount: %OldAmount% %LineBreak% View coupon in editor: %EditorLinkCoupon%',
						'woocommerce-coupon',
						'modified',
					),
					array(
						9066,
						WSAL_LOW,
						'User changed the coupon expire date of a coupon',
						'Changed the expire date of the coupon %CouponName% to %NewDate%. %LineBreak% Previous date: %OldDate% %LineBreak% View coupon in editor: %EditorLinkCoupon%',
						'woocommerce-coupon',
						'modified',
					),
					array(
						9067,
						WSAL_LOW,
						'User changed the usage restriction settings of a coupon',
						'Changed the <strong>Usage restriction</strong> of the coupon %CouponName% to %NewMetaValue%. %LineBreak% Usage restriction parameter: %MetaKey% %LineBreak% Previous value: %OldMetaValue% %LineBreak% View coupon in editor: %EditorLinkCoupon%',
						'woocommerce-coupon',
						'modified',
					),
					array(
						9068,
						WSAL_LOW,
						'User changed the usage limits settings of a coupon',
						'Change the <strong>Usage limits</strong> of the coupon %CouponName% to %NewMetaValue%. %LineBreak% Previous usage limits: %OldMetaValue% %LineBreak% View coupon in editor: %EditorLinkCoupon%',
						'woocommerce-store',
						'modified',
					),
					array(
						9069,
						WSAL_INFORMATIONAL,
						'User changed the description of a coupon',
						'Changed the description of the coupon %CouponName%. %LineBreak% Previous description: %OldDescription% %LineBreak% New description: %NewDescription% %LineBreak% View coupon in editor: %EditorLinkCoupon%',
						'woocommerce-coupon',
						'modified',
					),
					array(
						9070,
						E_WARNING,
						'User changed the status of a coupon',
						'Changed the status of WooCommerce coupon %CouponName% %LineBreak% Old status: %OldStatus% %LineBreak% New status: %NewStatus%',
						'woocommerce-coupon',
						'modified',
					),
					array(
						9071,
						WSAL_INFORMATIONAL,
						'User renamed a WooCommerce coupon',
						'Renamed the coupon %OldName% to %NewName%. %LineBreak% View coupon in editor: %EditorLinkCoupon%',
						'woocommerce-coupon',
						'renamed',
					),
				),
				'Orders'           => array(
					array(
						9035,
						WSAL_LOW,
						'A WooCommerce order has been placed',
						'A new order has been placed. %LineBreak% Order name: %OrderTitle% %LineBreak% View order: %EditorLinkOrder%',
						'woocommerce-order',
						'created',
					),
					array(
						9036,
						WSAL_INFORMATIONAL,
						'WooCommerce order status changed',
						'Marked the order %OrderTitle% as %OrderStatus%. %LineBreak% View order: %EditorLinkOrder%',
						'woocommerce-order',
						'modified',
					),
					array(
						9037,
						WSAL_MEDIUM,
						'User moved a WooCommerce order to trash',
						'Moved the order %OrderTitle% to trash %LineBreak% View order: %EditorLinkOrder%',
						'woocommerce-order',
						'deleted',
					),
					array(
						9038,
						WSAL_LOW,
						'User moved a WooCommerce order out of trash',
						'Restored the order %OrderTitle% out of the trash. %LineBreak% View order: %EditorLinkOrder%',
						'woocommerce-order',
						'restored',
					),
					array(
						9039,
						WSAL_LOW,
						'User permanently deleted a WooCommerce order',
						'Permanently deleted the order %OrderTitle%.',
						'woocommerce-order',
						'deleted',
					),
					array(
						9040,
						WSAL_MEDIUM,
						'User edited a WooCommerce order',
						'Changed the details in order %OrderTitle%. %LineBreak% View order: %EditorLinkOrder%',
						'woocommerce-order',
						'modified',
					),
					array(
						9041,
						WSAL_HIGH,
						'User refunded a WooCommerce order',
						'Refunded the order %OrderTitle%. %LineBreak% View order: %EditorLinkOrder%',
						'woocommerce-order',
						'modified',
					),
					array(
						9120,
						WSAL_HIGH,
						'User added/removed a product from an order',
						'The product %ProductTitle% to/from the order %OrderTitle%. %LineBreak% View order: %EditorLinkOrder%',
						'woocommerce-order',
						'added',
					),
				),
				'User Profile'     => array(
					array(
						9083,
						WSAL_INFORMATIONAL,
						'User changed the billing address details',
						'Changed <strong>billing address</strong> details of the user %TargetUsername% %LineBreak% Role: %Roles% %LineBreak% Previous billing address: %OldValue% %LineBreak% New Billing address: %NewValue% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
					array(
						9084,
						WSAL_INFORMATIONAL,
						'User changed the shipping address details',
						'Changed the <strong>shipping address</strong> details of the user %TargetUsername% %LineBreak% Role: %Roles% %LineBreak% Previous shipping address: %OldValue% %LineBreak% New Shipping address: %NewValue% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
				),
			),
			'bbPress Forums'                 => array(
				'Forums'                => array(
					array(
						8000,
						WSAL_INFORMATIONAL,
						'User created new forum',
						'Created a new forum called %ForumName%. %LineBreak% View the forum in editor: %EditorLinkForum%',
						'bbpress-forum',
						'created',
					),
					array(
						8001,
						WSAL_MEDIUM,
						'User changed status of a forum',
						'Changed the status of the forum %ForumName% to %NewStatus%. %LineBreak% Previous status: %OldStatus% %LineBreak% View the forum in editor: %EditorLinkForum%',
						'bbpress-forum',
						'modified',
					),
					array(
						8002,
						WSAL_MEDIUM,
						'User changed visibility of a forum',
						'Changed the visibility of the forum %ForumName% to %NewVisibility%. %LineBreak% Previous visibility: %OldVisibility% %LineBreak% View the forum in editor: %EditorLinkForum%',
						'bbpress-forum',
						'modified',
					),
					array(
						8003,
						WSAL_LOW,
						'User changed the URL of a forum',
						'Changed the URL of the forum %ForumName%. %LineBreak% Previous URL: %OldUrl% %LineBreak% New URL: %NewUrl% %LineBreak% View the forum in editor: %EditorLinkForum%',
						'bbpress-forum',
						'modified',
					),
					array(
						8004,
						WSAL_INFORMATIONAL,
						'User changed order of a forum',
						'Changed the sorting order of the forum %ForumName% to %NewOrder%. %LineBreak% Previous sorting order: %OldOrder% %LineBreak% View the forum in editor: %EditorLinkForum%',
						'bbpress-forum',
						'modified',
					),
					array(
						8005,
						WSAL_HIGH,
						'User moved forum to trash',
						'Moved the forum %ForumName% to trash.',
						'bbpress-forum',
						'deleted',
					),
					array(
						8006,
						WSAL_HIGH,
						'User permanently deleted forum',
						'Permanently deleted the forum %ForumName%.',
						'bbpress-forum',
						'deleted',
					),
					array(
						8007,
						WSAL_HIGH,
						'User restored forum from trash',
						'Restored the forum %ForumName% from trash.',
						'bbpress-forum',
						'restored',
					),
					array(
						8008,
						WSAL_LOW,
						'User changed the parent of a forum',
						'Changed the parent of the forum %ForumName% to %NewParent%. %LineBreak% Previous parent: %OldParent% %LineBreak% View the forum in editor: %EditorLinkForum%',
						'bbpress-forum',
						'modified',
					),
					array(
						8011,
						WSAL_LOW,
						'User changed type of a forum',
						'Changed the type of the forum %ForumName% to %NewType%. %LineBreak% Previous type: %OldType% %LineBreak% View the forum in editor: %EditorLinkForum%',
						'bbpress-forum',
						'modified',
					),
				),
				'bbPress Forum Topics'  => array(
					array(
						8014,
						WSAL_INFORMATIONAL,
						'User created new topic',
						'Created a new topic called %TopicName%. %LineBreak% View the topic in editor: %EditorLinkTopic%',
						'bbpress-forum',
						'created',
					),
					array(
						8015,
						WSAL_INFORMATIONAL,
						'User changed status of a topic',
						'Changed the status of the topic %TopicName% to %NewStatus%. %LineBreak% Previous status: %OldStatus% %LineBreak% View the topic in editor: %EditorLinkTopic%',
						'bbpress-forum',
						'modified',
					),
					array(
						8016,
						WSAL_INFORMATIONAL,
						'User changed type of a topic',
						'Changed the type of the topic %TopicName% to %NewType%. %LineBreak% Previous type: %OldType% %LineBreak% View the topic in editor: %EditorLinkTopic%',
						'bbpress-forum',
						'modified',
					),
					array(
						8017,
						WSAL_INFORMATIONAL,
						'User changed URL of a topic',
						'Changed the URL of the topic %TopicName%. %LineBreak% Previous URL: %OldUrl% %LineBreak% New URL: %NewUrl% %LineBreak% View the topic in editor: %EditorLinkTopic%',
						'bbpress-forum',
						'modified',
					),
					array(
						8018,
						WSAL_INFORMATIONAL,
						'User changed the forum of a topic',
						'Changed the forum of the topic %TopicName% to %NewForum%. %LineBreak% Previous forum: %OldForum% %LineBreak% View the topic in editor: %EditorLinkTopic%',
						'bbpress-forum',
						'modified',
					),
					array(
						8019,
						WSAL_MEDIUM,
						'User moved topic to trash',
						'Moved the %TopicName% to trash.',
						'bbpress-forum',
						'deleted',
					),
					array(
						8020,
						WSAL_MEDIUM,
						'User permanently deleted topic',
						'Permanently deleted the topic %TopicName%.',
						'bbpress-forum',
						'deleted',
					),
					array(
						8021,
						WSAL_INFORMATIONAL,
						'User restored topic from trash',
						'Restored the topic %TopicName% from trash.',
						'bbpress-forum',
						'restored',
					),
					array(
						8022,
						WSAL_LOW,
						'User changed visibility of a topic',
						'Changed the visibility of the topic %TopicName% to %NewVisibility%. %LineBreak% Previous visibility: %OldVisibility% %LineBreak% View the topic in editor: %EditorLinkTopic%',
						'bbpress-forum',
						'modified',
					),
				),
				'bbPress Settings'      => array(
					array(
						8009,
						WSAL_HIGH,
						'User changed forum\'s role',
						'Changed the bbPress setting <strong>Automatically give registered users a forum role</strong> to %NewRole%. %LineBreak% Previous role: %OldRole%',
						'bbpress',
						'modified',
					),
					array(
						8010,
						WSAL_CRITICAL,
						'User changed option of a forum',
						'Changed the bbPress setting <strong>Anonymous</strong> (allow guest users to post on the forums).',
						'bbpress',
						'enabled',
					),
					array(
						8012,
						WSAL_MEDIUM,
						'User changed time to disallow post editing',
						'Changed the time of the bbPress setting <strong>Editing</strong> (to allow users to edit their content after posting) to %NewTime%, %LineBreak% Previous time: %OldTime%',
						'bbpress',
						'modified',
					),
					array(
						8013,
						WSAL_HIGH,
						'User changed the forum setting posting throttle time',
						'Changed the time of the bbPress setting <strong>Flooding</strong> (throttling users setting) to %NewTime%. %LineBreak% Previous time: %OldTime%',
						'bbpress',
						'modified',
					),
				),
				'bbPress User Profiles' => array(
					array(
						8023,
						WSAL_LOW,
						'The forum role of a user was changed by another WordPress user',
						'Changed the role of user %TargetUsername% to %NewRole%. %LineBreak% Previous role: %OldRole% %LineBreak% First name: %FirstName% %LineBreak% User profile page: %EditUserLink%',
						'user',
						'modified',
					),
				),
			),
			'WPForms'                        => array(
				'Form Content' => array(
					array(
						5500,
						WSAL_LOW,
						'A form was created, modified or deleted',
						'The Form called %PostTitle%. %LineBreak% Form ID: %PostID% %LineBreak% View form in the editor: %EditorLinkForm%',
						'wpforms_forms',
						'created',
					),
					array(
						5501,
						WSAL_MEDIUM,
						'A field was created, modified or deleted from a form.',
						'The Field called %field_name% in the form %form_name%. %LineBreak% Form ID: %PostID% %LineBreak% View form in the editor: %EditorLinkForm%',
						'wpforms_fields',
						'deleted',
					),
					array(
						5502,
						WSAL_MEDIUM,
						'A form was duplicated',
						'Duplicated the form %OldPostTitle%. %LineBreak% Source form ID: %SourceID% %LineBreak% New form ID: %PostID% %LineBreak% View form in the editor: %EditorLinkFormDuplicated%',
						'wpforms_forms',
						'duplicated',
					),
					array(
						5503,
						WSAL_LOW,
						'A notification was added to a form, enabled or modified',
						'The Notification called %notifiation_name% in the form %form_name%. %LineBreak% Form ID: %PostID% %LineBreak% View form in the editor: %EditorLinkForm%',
						'wpforms_notifications',
						'added',
					),
					array(
						5504,
						WSAL_MEDIUM,
						'An entry was deleted',
						'Deleted the Entry with the email address %entry_email%. %LineBreak% Entry ID: %entry_id% %LineBreak% Form name: %form_name% %LineBreak% Form ID: %form_id% %LineBreak% View form in the editor: %EditorLinkForm%',
						'wpforms_entries',
						'deleted',
					),
					array(
						5505,
						WSAL_LOW,
						'Notifications were enabled or disabled in a form',
						'Changed the status of all the notifications in the form %form_name%. %LineBreak% Form ID: %PostID% %LineBreak% View form in the editor: %EditorLinkForm%',
						'wpforms_notifications',
						'deleted',
					),
					array(
						5506,
						WSAL_LOW,
						'A form was renamed',
						'Renamed the form %old_form_name% to %new_form_name%. %LineBreak% Form ID: %PostID% %LineBreak% View form in the editor: %EditorLinkForm%',
						'wpforms_forms',
						'renamed',
					),
					array(
						5507,
						WSAL_MEDIUM,
						'An entry was modified',
						'Modified the Entry with ID %entry_id%. %LineBreak% From form: %form_name% %LineBreak% Modified field name: %field_name% %LineBreak% Previous value: %old_value% %LineBreak% New Value: %new_value% %LineBreak% View entry in the editor: %EditorLinkEntry%',
						'wpforms_entries',
						'modified',
					),
					array(
						5508,
						WSAL_HIGH,
						'Plugin access settings were changed',
						'Changed the WPForms access setting %setting_name%. %LineBreak% Type: %setting_type% %LineBreak% Previous privileges: %old_value% %LineBreak% New privileges: %new_value%',
						'wpforms',
						'modified',
					),
					array(
						5509,
						WSAL_HIGH,
						'Currency settings were changed',
						'Changed the <strong>currency</strong> to %new_value%. %LineBreak% Previous currency: %old_value%',
						'wpforms',
						'modified',
					),
					array(
						5510,
						WSAL_HIGH,
						'A service integration was added or deleted',
						'A service integration with %service_name%. %LineBreak% Connection name: %connection_name% %LineBreak% Service: %service_name%',
						'wpforms',
						'added',
					),
					array(
						5511,
						WSAL_HIGH,
						'An addon was installed, activated or deactivated.',
						'The addon %addon_name%.',
						'wpforms',
						'activated',
					),
				),
			),

		)
	);

	add_filter( 'wsal_event_objects', 'mwpal_dynamic_objects_init', 10, 1 );
	add_filter( 'wsal_event_type_data', 'mwpal_dynamic_event_types_init', 10, 1 );
}

function mwpal_dynamic_objects_init( $objects ) {
	return array_merge(
		$objects,
		array(
			'activity-log'               => 'Activity log',
			'category'                   => 'Category',
			'comment'                    => 'Comment',
			'custom-field'               => 'Custom Field',
			'database'                   => 'Database',
			'file'                       => 'File',
			'ip-address'                 => 'IP Address',
			'mainwp'                     => 'MainWP',
			'mainwp-network'             => 'MainWP Network',
			'menu'                       => 'Menu',
			'multisite-network'          => 'Multisite Network',
			'plugin'                     => 'Plugin',
			'post'                       => 'Post',
			'setting'                    => 'Setting',
			'system'                     => 'System',
			'system-setting'             => 'System Setting',
			'tag'                        => 'Tag',
			'theme'                      => 'Theme',
			'user'                       => 'User',
			'wp-activity-log'            => 'WP Activity Log',
			'widget'                     => 'Widget',
			'yoast-seo'                  => 'Yoast SEO',
			'yoast-seo-metabox'          => 'Yoast SEO Meta Box',
			'gravityforms_forms'         => 'Forms in Gravity Forms',
			'gravityforms_confirmations' => 'Confirmations in Gravity Forms',
			'gravityforms_notifications' => 'Notifications in Gravity Forms',
			'gravityforms_entries'       => 'Entries in Gravity Forms',
			'gravityforms_fields'        => 'Fields in Gravity Forms',
			'gravityforms_settings'      => 'Settings in Gravity Forms',
			'tablepress_tables'          => 'TablePress',
			'woocommerce-product'        => 'WooCommerce Product',
			'woocommerce-store'          => 'WooCommerce Store',
			'woocommerce-coupon'         => 'WooCommerce Coupon',
			'woocommerce-category'       => 'WooCommerce Category',
			'woocommerce-tag'            => 'WooCommerce Tag',
			'woocommerce-order'          => 'WooCommerce Order',
			'bbpress'                    => 'BBPress',
			'bbpress-forum'              => 'BBPress Forum',
			'wpforms'                    => 'WPForms',
			'wpforms-notifications'      => 'Notifications in WPForms',
			'wpforms_notifications'      => 'Notifications in WPForms',
			'wpforms-entries'            => 'Entries in WPForms',
			'wpforms_entries'            => 'Entries in WPForms',
			'wpforms-fields'             => 'Fields in WPForms',
			'wpforms_fields'             => 'Fields in WPForms',
			'wpforms_forms'              => 'Forms in WPForms',
		)
	);
}

function mwpal_dynamic_event_types_init( $types ) {
	return array_unique(
		array_merge(
			$types,
			array(
				'activated'    => 'Activated',
				'added'        => 'Added',
				'approved'     => 'Approved',
				'blocked'      => 'Blocked',
				'created'      => 'Created',
				'deactivated'  => 'Deactivated',
				'deleted'      => 'Deleted',
				'disabled'     => 'Disabled',
				'duplicated'   => 'Duplicated',
				'enabled'      => 'Enabled',
				'failed-login' => 'Failed Login',
				'installed'    => 'Installed',
				'login'        => 'Login',
				'logout'       => 'Logout',
				'modified'     => 'Modified',
				'opened'       => 'Opened',
				'published'    => 'Published',
				'removed'      => 'Removed',
				'renamed'      => 'Renamed',
				'restored'     => 'Restored',
				'revoked'      => 'Revoked',
				'started'      => 'Started',
				'stopped'      => 'Stopped',
				'submitted'    => 'Submitted',
				'unapproved'   => 'Unapproved',
				'unblocked'    => 'Unblocked',
				'uninstalled'  => 'Uninstalled',
				'updated'      => 'Updated',
				'uploaded'     => 'Uploaded',
				'viewed'       => 'Viewed',
				'starred'      => 'Starred',
				'unstarred'    => 'Unstarred',
				'read'         => 'Read',
				'unread'       => 'Unread',
				'imported'     => 'Imported',
				'downloaded'   => 'Downloaded',
			)
		)
	);
}

add_action( 'init', 'mwpal_dynamic_events_init', 20 );
