<?php
/**
 * Returns an array of translatable strings to be used in javascript.
 */

if (!defined('UD_CENTRAL_DIR')) die('Security check');

$uc_debug_level = 0;

if (defined('UPDRAFTCENTRAL_DEBUG_LEVEL') && UPDRAFTCENTRAL_DEBUG_LEVEL) {
	$uc_debug_level = UPDRAFTCENTRAL_DEBUG_LEVEL;
} elseif (defined('UPDRAFTCENTRAL_DEV_ENVIRONMENT') && UPDRAFTCENTRAL_DEV_ENVIRONMENT) {
	$uc_debug_level = 1;
}

return array(
	'ajaxurl' => admin_url('admin-ajax.php', 'relative'),
	'debug_level' => $uc_debug_level,
	'updraftcentral_dashboard_nonce' => wp_create_nonce('updraftcentral_dashboard_nonce'),
	'error' => __('Error', 'updraftcentral'),
	'communications_error' => __('Communications error', 'updraftcentral'),
	'add_site' => __('Add website', 'updraftcentral'),
	'advanced_options' => __('Advanced options', 'updraftcentral'),
	'could_not_parse' => __('The response was not understood.', 'updraftcentral').' '.__('You can check the browser JavaScript console for more information.', 'updraftcentral'),
	'unknown_response' => __('The response was not understood (no message included).', 'updraftcentral').' '.__('You can check the browser JavaScript console for more information.', 'updraftcentral'),
	'remove_site' => __('Remove site', 'updraftcentral'),
	'really_delete_site' => __('Do you really wish to delete this site from your dashboard?', 'updraftcentral'),
	'what_remote_running' => __('This site is running WordPress version %s (PHP %s, MySQL %s) and UpdraftPlus version %s (UDRPC version %s)', 'updraftcentral'),
	'updraftcentral_version' => __('UpdraftCentral version', 'updraftcentral'),
	'js_exception_occurred' => __("An error occurred - you may find more information in your web browser's JavaScript console.", 'updraftcentral'),
	'test_other_connection_methods' => __('Follow this link to test alternative connection methods', 'updraftcentral'),
	'test_connection_methods' => __('Test connection methods', 'updraftcentral'),
	'testing' => __('Testing...', 'updraftcentral'),
	'failed' => __('Failed', 'updraftcentral'),
	'succeeded' => __('Succeeded.', 'updraftcentral'),
	'general_js_comms_failure' => __('There was an error in contacting the remote site.', 'updraftcentral').' '.__("You should check that the remote site is online, is not firewalled, has remote control enabled, and that no security module is blocking the access. Then, check the logs on the remote site and your browser's JavaScript console.", 'updraftcentral').' '.__('If none of that helps, then you should try re-adding the site with a fresh key.', 'updraftcentral'),
	'general_ajax_comms_failure' => __('There was an error in contacting either the dashboard server or the remote site.', 'updraftcentral').' '.__("You should check that the dashboard website is online, and that the remote site is online, is not firewalled, has remote control enabled, and that no security module is blocking the access. Then, check the logs on the remote site and your browser's JavaScript console.", 'updraftcentral').' '.__('If none of that helps, then you should try re-adding the site with a fresh key.', 'updraftcentral'),
	'comms_failure_timeout' => __('There was an error in contacting the remote site.', 'updraftcentral').' '.__('The request did not complete in a reasonable amount of time.', 'updraftcentral').' '.__('You should check that the remote site is online, is not firewalled, has remote control enabled, and that no security module is blocking the access. Then, check the logs on the remote site.', 'updraftcentral'),
	'timeout' => __('timeout', 'updraftcentral'),
	'comms_failure_unauthorised' => __('There was an error in contacting the remote site.', 'updraftcentral').' '.__("The request to the remote site was blocked by the site's webserver as unauthorized.", 'updraftcentral'),
	'comms_failure_unauthorised_by_browser' => __('There was an error in contacting the remote site.', 'updraftcentral').' '.__('The request to the remote site was blocked by your web browser as unauthorized.', 'updraftcentral'),
	'http_response_status' => __('HTTP response status code', 'updraftcentral'),
	'error_code' => __('Error code', 'updraftcentral'),
	'site' => __('Site', 'updraftcentral'),
	'open_site_configuration' => __('Open site configuration', 'updraftcentral'),
	'description' => __('Description', 'updraftcentral'),
	'go' => __('Go', 'updraftcentral'),
	'close' => __('Close', 'updraftcentral'),
	'edit' => __('Edit', 'updraftcentral'),
	'edit_site_configuration' => __('Edit site configuration', 'updraftcentral'),
	'phpinfo' => __('PHP installation information', 'updraftcentral'),
	'paste_key' => __('To connect to a remote site, paste its key here:', 'updraftcentral'),
	'unknown_key' => __('The remote site did not recognise the communications key - you are recommended to delete and re-create it.', 'updraftcentral'),
	'already_have' => __('The remote site has already received the communications key', 'updraftcentral'),
	'go_here_for_help_including_screenshots' => __('Need help adding a site?', 'updraftcentral'),
	'go_here_for_connection_help' => __('Go here for help in trouble-shooting connection issues', 'updraftcentral'),
	'http_authentication_if_any' => __('HTTP Authentication', 'updraftcentral'),
	'http_authentication_explan' => __('For sites protected by a password', 'updraftcentral'),
	'http_authentication_method' => __('Authentication Method'),
	'http_username' => __('HTTP Authentication Username', 'updraftcentral'),
	'http_password' => __('HTTP Authentication Password', 'updraftcentral'),
	'basic' => __('Basic', 'updraftcentral'),
	'digest' => __('Digest', 'updraftcentral'),
	'send_cors_headers' => __('Send CORS headers', 'updraftcentral'),
	'send_cors_headers_explanation' => __('CORS headers should normally be turned on, so that UpdraftCentral on the remote site sends these necessary headers. You would only turn it off if you have set something else up to manually add them (which may be necessary for you to do if you are using HTTP authentication).', 'updraftcentral'),
	'digest_auth_not_supported' => __('The remote site is protected by HTTP digest authentication, which UpdraftCentral does not support in this connection mode (via mothership).', 'updraftcentral'),
	'connection_method' => __('Connection method', 'updraftcentral'),
	'test_not_possible_in_current_mode' => __('These tests cannot currently be run. You must first change and save the site configuration to take it out of the "Via mothership (dashboard webserver), encryption performed at the mothership" mode, in order to be able to perform the connection tests. This is because in the current mode, some of the information for testing direct connections has not been shared with the browser, to enhance security.', 'updraftcentral'),
	'run_connection_test' => __('Run a connection method test by following this link', 'updraftcentral'),
	'get_advanced_connection_help' => __('Get help on complicated setups and connection methods at this link.', 'updraftcentral'),
	'http_must_go_via_mothership' => sprintf(__('Because of %s, any connections to http sites must go via the mothership (dashboard webserver) - and the option chosen here will make no difference', 'updraftcentral'), '<a target="_blank" href="https://developer.mozilla.org/en-US/docs/Security/Mixed_content">'.__('web browser security restrictions', 'updraftcentral').'</a>'),
	'direct' => __('Direct', 'updraftcentral'),
	'direct_default_auth' => __('Direct when possible (authentication method chosen automatically)', 'updraftcentral'),
	'direct_jquery_auth' => __('Direct when possible (authentication via jQuery)', 'updraftcentral'),
	'direct_manual_auth' => __('Direct when possible (manually constructed authentication)', 'updraftcentral'),
	'not_yet_begun' => __('Not yet begun', 'updraftcentral'),
	'via_mothership_short' => __('Via mothership (encrypted from the browser)', 'updraftcentral'),
	'via_mothership_encrypting_short' => __('Via mothership (encrypted at the mothership)', 'updraftcentral'),
	'via_mothership' => __('Via mothership (slower, but better compatibility with some awkward setups)', 'updraftcentral'),
	'via_mothership_encrypting' => __('Via mothership, encryption performed at the mothership (useful for slow browsers, but less secure)', 'updraftcentral'),
	'localdev_can_work_better_with_https' => __('Browser security restrictions preventing https dashboards contacting non-https sites may be involved here. You could try setting up https (i.e. SSL) for your site-local website, visiting its dashboard over https, and getting a new key for it.', 'updraftcentral'),
	'method' => __('Method (in recommended order)', 'updraftcentral'),
	'result' => __('Result', 'updraftcentral'),
	'not_possible_browser_restrictions' => __('Not possible (due to browser security restrictions on non-https sites)', 'updraftcentral'),
	'best_method' => __('This is the best connection method.', 'updraftcentral'),
	'recommend_keep' => __('You are recommended to continue using it.', 'updraftcentral'),
	'recommend_use' => __('You are recommended to use it.', 'updraftcentral'),
	'current_method' => __('This is the current method.', 'updraftcentral'),
	'switch_to' => __('Switch to using this method', 'updraftcentral'),
	'settings' => __('Settings', 'updraftcentral'),
	'save_settings' => __('Save settings', 'updraftcentral'),
	'debugging_level' => __('Debugging level', 'updraftcentral'),
	'debugging_level_this_session' => __("for this session only - controls the amount of output in the web browser's console", 'updraftcentral'),
	'window_may_be_blocked' => __('The request to open a new browser window/tab was made, but that window/tab was not immediately found - if you have a pop-up blocker, then please check it (e.g. it may be showing something in the browser address bar).', 'updraftcentral'),
	'open_new_window' => __('Opening a new window/tab', 'updraftcentral'),
	'updraftcentral_help' => __('UpdraftCentral Help', 'updraftcentral'),
	'follow_one_for_help' => __('Follow one of these links to get help with UpdraftCentral', 'updraftcentral'),
	'how_to_install' => __('How to install UpdraftCentral', 'updraftcentral'),
	'how_to_add_site' => __('How to add a site to UpdraftCentral', 'updraftcentral'),
	'faqs' => __('Frequently asked questions', 'updraftcentral'),
	'make_a_suggestion' => __('Make a suggestion / feature request', 'updraftcentral'),
	'paid_support_requests' => __('Paid support requests', 'updraftcentral'),
	'support_forum' => __('Support forum', 'updraftcentral'),
	'site_unlicensed_message' => apply_filters('updraftcentral_site_unlicensed_message', __('You have more sites in your dashboard than licences. As a result, you cannot perform actions on this site.', 'updraftcentral').' '.__('You will need to obtain more licences, or remove some sites.', 'updraftcentral')),
	'browser_cache' => __('UC browser cache', 'updraftcentral'),
	'empty' => __('Empty'),
	'log_contents' => __('Log contents', 'updraftcentral'),
	'cache_no_contents' => __('The UpdraftCentral browser cache currently has no contents', 'updraftcentral'),
	'cache_emptied' => __('The UpdraftCentral browser cache was emptied - %s items were removed', 'updraftcentral'),
	'cache_contents_logged' => __('The UpdraftCentral browser cache contents have been logged in the browser developer console.', 'updraftcentral'),
	// Text messages corresponding to returned error codes for RPC calls
	'rpcerrors' => array(
		'ud_get_fragment_could_not_return' => __('The site could not return the requested information - perhaps you need to update it to a more recent UpdraftPlus version?', 'updraftcentral'),
		'unknown_rpc_command' => __('The remote site did not recognise the command.', 'updraftcentral').' '.sprintf(__('Possibly you need to update the remote site to a more recent %s version.', 'updraftcentral'), 'UpdraftPlus'),
		'rpc_fatal_error' => __('The remote site has encountered a fatal error while executing the requested command. Remote response follows: %s', 'updraftcentral')
	),
	'unsupported_browser' => __('Your web browser lacks capabilities that UpdraftCentral requires, and thus is not supported. Please update your browser to the latest version.', 'updraftcentral'),
	'search' => __('Search', 'updraftcentral'),
	'failed_credentials_heading' => __('Invalid Credentials', 'updraftcentral'),
	'failed_credentials' => __('The credentials you entered did not give the desired access. Please check that your server is properly configured for access, and that you have entered the correct credentials.', 'updraftcentral'),
	'credentials_ok' => __('Credentials appears to be valid.', 'updraftcentral'),
	'tasks_queue_empty' => __('There are currently no tasks available to execute.', 'updraftcentral'),
	'process_completed' => __('The update process has completed. Refreshing...', 'updraftcentral'),
	'processing' => __('Processing', 'updraftcentral'),
	'process_aborted' => __('Process halted due to errors.', 'updraftcentral'),
	'error_saving_site_order' => __('There was an error when saving the site order.', 'updraftcentral'),
	'drag_to_set_the_site_order' => __('Drag to set the site order', 'updraftcentral'),
	'no_site_selected' => __('No site selected', 'updraftcentral'),
	'selected_site' => __('Selected site', 'updraftcentral'),
	'keyboard_shortcuts_link' => __('Show keyboard shortcuts', 'updraftcentral'),
	'keyboard_shortcuts_help' => __('Show keyboard shortcuts (this window)', 'updraftcentral'),
	'keyboard_shortcuts_heading' => __('Keyboard shortcuts', 'updraftcentral'),
	'keyboard_shortcuts_message' => __("Most of these shortcuts operate on the currently selected site. If no site is currently selected, then the first site in your list will be used. You may change the default shortcuts, but be sure that your new shortcut does not conflict with your browser's own shortcut keys, otherwise, it won't work or may cause some unexpected behaviour. Shortcuts are case-insensitive and only alphabetic (A-Z) characters are allowed.", 'updraftcentral'),
	'keyboard_change_shortcut' => __('change', 'updraftcentral'),
	'keyboard_save_shortcut' => __('save', 'updraftcentral'),
	'keyboard_cancel_shortcut' => __('cancel', 'updraftcentral'),
	'keyboard_choose_modifiers' => __('Choose modifiers', 'updraftcentral'),
	'keyboard_new_shortcut' => __('New shortcut', 'updraftcentral'),
	'keyboard_shortcut_required_heading' => __('Key character required', 'updraftcentral'),
	'keyboard_shortcut_required' => __('You need to input an alphabetic character (a-z/A-Z) in order to save the new shortcut.', 'updraftcentral'),
	'show_comments' => __('Show comments', 'updraftcentral'),
	'show_users' => __('Show users', 'updraftcentral'),
	'show_analytics' => __('Show analytics', 'updraftcentral'),
	'keyboard_invalid_key' => __('Invalid key', 'updraftcentral'),
	'keyboard_shortcut_exist_heading' => __('Shortcut unavailable', 'updraftcentral'),
	'keyboard_shortcut_exist' => __('The shortcut you wish to save has already been taken. Please choose a different shortcut.', 'updraftcentral'),
	'all_sites_selected' => __('All sites selected. Previous site selection cleared.', 'updraftcentral'),
	'site_update' => __('Site update', 'updraftcentral'),
	'reset_shortcuts' => __('Reset shortcuts', 'updraftcentral'),
	'shortcut_key' => __('Shortcut key', 'updraftcentral'),
	'notice_heading' => __('Please wait, action in progress', 'updraftcentral'),
	'currently_processing' => __('An action is currently in progress. Please wait for the process to complete before doing anything else.'),
	'standard' => __('Standard', 'updraftcentral'),
	'advanced' => __('Advanced', 'updraftcentral'),
	'show_all' => __('Show All', 'updraftcentral'),
	'hidden_modules' => __('Hidden Modules', 'updraftcentral'),
	'plugin_insufficient_permission' => __('Sorry, you are not allowed to install or activate plugins on the remote site.', 'updraftcentral'),
	'plugin_install_failed' => __('UpdraftCentral failed to install the %s plugin on the remote website.', 'updraftcentral'),
	'plugin_not_installed' => __('It appears that the %s plugin is not installed. Press the "Install and Activate" button to download, install and activate the plugin on the remote website.', 'updraftcentral'),
	'plugin_not_activated' => __('It appears that the %s plugin is installed but not activated. Press the "Activate" button to activate the plugin on the remote website.', 'updraftcentral'),
	'plugin_install_and_activate' => __('Install and Activate', 'updraftcentral'),
	'plugin_activate' => __('Activate', 'updraftcentral'),
	'plugin_name_required' => __('Plugin name is required.', 'updraftcentral'),
	'plugin_slug_required' => __('Plugin slug is required.', 'updraftcentral'),
	'collapse_menu' => __('Collapse menu', 'updraftcentral'),
	'expand_menu' => __('Expand menu', 'updraftcentral'),
	'return_to_updates' => __('Return to the "updates" screen', 'updraftcentral'),
	'add_user' => __('Add user', 'updraftcentral'),
	'timeout_header' => __('Timeout', 'updraftcentral'),
	'timeout_subheading' => __('The maximum number of seconds until the request times out and the current process is stopped. Adjust it to your specific needs and requirements.', 'updraftcentral'),
	'seconds' => __('seconds', 'updraftcentral'),
	'generic_response_error' => __('An error has occurred while processing your request. Please refer to the following error: %s', 'updraftcentral'),
	'press_to_select_website' => __('Press to select and add a website', 'updraftcentral'),
	'submit' => __('Submit', 'updraftcentral'),
	'page_of' => __('Page %s of %s', 'updraftcentral'),
	'previous' => __('Previous', 'updraftcentral'),
	'next' => __('Next', 'updraftcentral'),
	'first' => __('First', 'updraftcentral'),
	'last' => __('Last', 'updraftcentral'),
	'total_items' => __('%s-%s of %s items', 'updraftcentral'),
	'ok' => __('OK', 'updraftcentral'),
	'cancel' => __('Cancel', 'updraftcentral'),
	'add_all_sites' => __('All managed sites', 'updraftcentral'),
	'add_all_sites_tagged' => __('Add all sites tagged: %s', 'updraftcentral'),
	'export_import_settings' => __('Export/Import settings', 'updraftcentral'),
	'export_settings' => __('Export settings', 'updraftcentral'),
	'import_settings' => __('Import settings', 'updraftcentral'),
	'export_heading' => __('Export', 'updraftcentral'),
	'export_message' => __('Without an encryption phrase, your exported data is in plain text. Anyone who gets access to the unencrypted file would be able to control the exported sites. Keep the phrase somewhere safe and do not lose it (there is no other way to decrypt the file).', 'updraftcentral'),
	'import_heading' => __('Import', 'updraftcentral'),
	'add_phrase' => __('Add an encryption phrase', 'updraftcentral'),
	'use_phrase' => __('Use phrase for decryption', 'updraftcentral'),
	'encryption_phrase' => __('Encryption phrase', 'updraftcentral'),
	'decryption_phrase' => __('Decryption phrase', 'updraftcentral'),
	'import_response_heading' => __('Import response', 'updraftcentral'),
	'import_successful' => __('Import process has succeeded. Your UpdraftCentral dashboard will now be reloaded to refresh your sites list.', 'updraftcentral'),
	'encryption_phrase_required' => __('You have chosen encryption, but not entered an encryption phrase.', 'updraftcentral'),
	'keyboard_settings_message' => __('Shortcuts are here to help you navigate UpdraftCentral features more quickly. If you wish to deactivate them, you can do so via the checkbox below.', 'updraftcentral'),
	'tick_to_activate' => __('Tick to activate', 'updraftcentral'),
	'configure_shortcuts' => __('Configure shortcuts', 'updraftcentral'),
	'message' => __('Message', 'updraftcentral'),
	'yes_activate' => __('Yes, activate', 'updraftcentral'),
	'do_not_activate' => __('Do not activate', 'updraftcentral'),
	'close_editor' => __('Close editor', 'updraftcentral'),
	'switch_to_draft' => __('Switch to draft', 'updraftcentral'),
	'preview_changes' => __('Preview changes', 'updraftcentral'),
	'permalink' => __('Permalink', 'updraftcentral'),
	'editor_nojs_message' => __('JavaScript is required for the block editor to work.', 'updraftcentral'),
	'load_header' => __('Load setting', 'updraftcentral'),
	'load_subheading' => __('By default UpdraftCentral fills the entire content area when it loads. If you don\'t wish to load UpdraftCentral that way, then un-tick the checkbox below. You may need to reload the browser after saving for the new settings to take effect.', 'updraftcentral'),
	'tick_to_fill' => __('Tick to fill the entire content area on load', 'updraftcentral'),
);
