<?php

namespace WPUmbrella\Actions\Queue\Scheduler;

use Exception;
use WPUmbrella\Core\Hooks\ExecuteHooks;
use WPUmbrella\Core\Scheduler\AsyncQueueRunner;
use WPUmbrella\Core\Scheduler\QueueRunner;
use WPUmbrella\Services\Scheduler\ScheduleErrorCheck;
use WPUmbrella\Services\Scheduler\SchedulerLock;

class ErrorCheckQueueRunner implements ExecuteHooks
{

	use QueueRunner;
	use AsyncQueueRunner;

	const CRON_HOOK = 'wp_umbrella_error_check_run_queue';
	const CRON_SCHEDULE = 'every_five_minutes';
	const LOCK_KEY = 'wp_umbrella_error_check_queue_runner';
	const INTERVAL = 5 * 60;

	/**
	 * @var ScheduleErrorCheck
	 */
	protected $scheduler;

	/**
	 * @var SchedulerLock
	 */
	protected $schedulerLock;

	public function __construct()
	{
		$this->scheduler     = wp_umbrella_get_service('ScheduleErrorCheck');
		$this->schedulerLock = wp_umbrella_get_service('SchedulerLock');
	}

	/**
	 * @throws Exception
	 */
	public function hooks()
	{
		add_filter('cron_schedules', [$this, 'addCronSchedules']);
		$this->cronHooks();
		$this->asyncHooks();
	}

	public function addCronSchedules($schedules)
	{
		$schedules[self::CRON_SCHEDULE] = array(
			'interval' => self::INTERVAL,
			'display'  => __('Every five minutes'),
		);

		return $schedules;
	}
}
