<?php
namespace WPUmbrella\Controller\Options;

use WPUmbrella\Core\Models\AbstractController;

class WhiteLabel extends AbstractController
{
    public function executePost($params)
    {

		$defaultData = wp_umbrella_get_service('WhiteLabel')->getDefaultData();

		$data = [
			'hide_plugin' => $params['hide_plugin'] ?? $defaultData['hide_plugin'],
			'plugin_name' => $params['plugin_name'] ?? $defaultData['plugin_name'],
			'plugin_description' => $params['plugin_description'] ?? $defaultData['plugin_description'],
			'plugin_author' => $params['plugin_author'] ?? $defaultData['plugin_author'],
			'plugin_author_url' => $params['plugin_author_url'] ?? $defaultData['plugin_author_url'],
			'logo' => $params['logo'] ?? $defaultData['logo'],
			'data' => [
				'catchphrase' => $params['data']['catchphrase'] ?? $defaultData['catchphrase'],
				'catchphrase_2' => $params['data']['catchphrase_2'] ?? $defaultData['catchphrase_2'],
			],
			'view_company_details' => $params['view_company_details'] ?? $defaultData['view_company_details'],
			'email_support' => $params['email_support'] ?? null,
			'maintenance_report_data' => $params['maintenance_report_data'] ?? null,
			'company_details' => $params['company_details'] ?? null,
		];

        wp_umbrella_get_service('WhiteLabel')->setData($data);

        return $this->returnResponse(['success' => true]);
    }
}
