<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;
use ZipArchive;


class CreatePartsRestoreFilesHandler extends RestoreProcessHandler implements CaretakerHandler
{
	const MAX_SIZE = 1048576 * 128; // default 128MB


	public function getWPFilesCore(){

		return [
			[
				"type" => "directory",
				"path" => 'wp-admin/',
			],
			[
				"type" => "directory",
				"path" => 'wp-includes/'
			],
			[
				"type" => "file",
				"path" => '.htaccess',
			],
			[
				"type" => "file",
				"path" => 'index.php',
			],
			[
				"type" => "file",
				"path" => 'wp-config.php',
			],
			[
				"type" => "file",
				"path" => 'wp-comments-post.php',
			],
			[
				"type" => "file",
				"path" => 'wp-cron.php',
			],
			[
				"type" => "file",
				"path" => 'wp-load.php',
			],
			[
				"type" => "file",
				"path" => 'wp-login.php',
			],
			[
				"type" => "file",
				"path" => 'wp-mail.php',
			],
			[
				"type" => "file",
				"path" => 'wp-settings.php',
			],
			[
				"type" => "file",
				"path" => 'wp-signup.php',
			],
			[
				"type" => "file",
				"path" => 'wp-trackback.php',
			],
			[
				"type" => "file",
				"path" => 'xmlrpc.php',
			],
			[
				"type" => "file",
				"path" => 'wp-activate.php',
			],
			[
				"type" => "file",
				"path" => 'wp-blog-header.php',
			],
			[
				"type" => "file",
				"path" => 'wp-config-sample.php',
			],
			[
				"type" => "file",
				"path" => 'wp-links-opml.php',
			],
		];
	}

    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);

        $path = $originator->getValueInState('zip_files_path');

        if ($path === null || !file_exists($path)) {
            $this->setFailHandler($data, [
                'error_code' => 'resprepare_tore_files_handler',
            ]);
            return false;
        }

		if(file_exists(ABSPATH . 'wp-admin/includes/file.php')){
			require_once ABSPATH . 'wp-admin/includes/file.php';
			WP_Filesystem();
		}


        try {
            wp_umbrella_get_service('LogProcess')->log('Create parts files for unzip', [
                'logfile' => $this->getLogfile($originator->getState()),
            ]);

			@set_time_limit(0);

			$zip = new ZipArchive();
			$open = $zip->open($path);
			if($open !== true) {
				$this->setFailHandler($data, [
					'error_code' => 'restore_prepare_files_handler_open',
					'error_message' => 'Failed to open zip file',
				]);
				return false;
			}

			$maxFiles = $zip->numFiles;
			$iterator = 0;

			$part = 0;
			$size = 0;
			$filenameConfigPart = 'backup-files-part-%s.json';
			$filenameConfigCore = 'backup-files-part-core.json';
			$current = [];
			$configParts = [];

			$currentFilesCore = [];

			$filesInCore = $this->getWPFilesCore();

			do {

				$stat = $zip->statIndex($iterator);
				if(!$stat){
					$iterator++;
					continue;
				}

				// Don't restore umbrella files
				if(strpos($stat['name'], 'wp-health') !== false){
					$iterator++;
					continue;
				}

				$fileInCore = false;
				foreach ($filesInCore as $key => $file) {
					if($file['type'] === 'directory' && strpos($stat['name'], $file['path']) !== false){
						$fileInCore = true;
						break;
					}
					else if($file['type'] === 'file' && $stat['name'] === $file['path']){
						$fileInCore = true;
						break;
					}
				}


				if($fileInCore){
					$currentFilesCore[] = $stat['name'];
				}
				else{
					$size += $stat['size'];

					$current[] = $stat['name'];

					// Add part for new batch
					if( $size > self::MAX_SIZE ){
						$filenamePart = sprintf('%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, sprintf($filenameConfigPart, $part));
						file_put_contents($filenamePart, json_encode($current));
						$configParts[] = $filenamePart;
						$size = 0;
						$part++;
						$current = [];
					}
				}

				$iterator++;


			} while($iterator < $maxFiles );

			$filenameCore= sprintf('%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, $filenameConfigCore);
			file_put_contents($filenameCore, json_encode($currentFilesCore));
			array_unshift($configParts, $filenameCore);

			$originator->setValueInState('zip_files_parts', $configParts);

			$zip->close();

        } catch (\Exception $e) {
            $this->setFailHandler($data, [
                'error_code' => 'restore_prepare_files_exception_handler',
                'error_message' => $e->getMessage()
            ]);
            return false;
        }

		wp_umbrella_get_service('RestoreRunner')->scheduledRestoreFiles();


        $data['originator'] = $originator;

        return parent::handle($data);
    }
}
