<?php
namespace WPUmbrella\Core\Restore\ChainResponsibility;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\ChainResponsibility\RestoreProcessHandler;
use WPUmbrella\Core\Restore\Memento\CaretakerHandler;
use WPUmbrella\Core\Restore\Memento\RestoreOriginator;

class WordPressLoadDataSqlHandler extends RestoreProcessHandler implements CaretakerHandler
{
    public function handle($data)
    {
        $originator = $this->getOriginatorByData($data);

        try {
            /**
             * Load config SQL
             */
            $file = 'config.php';
            $path = sprintf('%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, $file);
            if (!file_exists($path)) {
                $this->setFailHandler($data, [
                    'error_code' => 'wordpress_load_data_sql',
                ]);

                return false;
            }

            require_once $path;
        } catch (\Exception $e) {
            $this->setFailHandler($data, [
                'error_code' => 'wordpress_load_data_sql',
                'error_message' => $e->getMessage(),
            ]);

            return false;
        }

        $data['originator'] = $originator;

        return parent::handle($data);
    }
}
