<?php
namespace WPUmbrella\Core;

use WPUmbrella\Services\Restore\V2\RestorationDirectory;

class UmbrellaRequest
{

	protected $checkTypeQuery = null;

	protected $query = [];

	protected $request = [];

	protected $cookies = [];

	protected $headers = [];

	/**
	 * @var array
	 */
    public function __construct($options)
    {
        $this->query      = $options['query'] ?? [];
        $this->request    = $options['request'] ?? [];
        $this->cookies    = $options['cookies'] ?? [];
        $this->headers    = $options['headers'] ?? [];


		$restorationDirectory = wp_umbrella_get_service(RestorationDirectory::class);
		$restorationDirectory->loadSecureFile();

    }


    public function getMethod()
    {
        if (null === $this->method) {
            $this->method = isset($this->server['REQUEST_METHOD']) ? strtoupper($this->server['REQUEST_METHOD']) : 'GET';
        }

        return $this->method;
    }

    public static function createFromGlobals()
    {
        $request = new self([
			'query'   => $_GET,
			'request' => $_POST,
			'cookies' => $_COOKIE,
			'headers' => wp_umbrella_get_headers(),
		]);

		$request->setTypeQuery();

        return $request;
    }

	protected function setTypeQuery(){


		if(isset($this->headers['x-umbrella']) && (isset($this->headers['x-project']) || isset($this->headers['x-secret-token']) || isset($this->headers['x-auth-token']) )){
			$this->checkTypeQuery = 'headers';
		}

		if(isset($this->request['x-umbrella']) && (isset($this->request['x-project']) || isset($this->request['x-secret-token']) || isset($this->request['x-auth-token']) )){
			$this->checkTypeQuery = 'post';
		}

		if(isset($this->query['x-umbrella']) && (isset($this->query['x-project']) || isset($this->query['x-secret-token']) || isset($this->query['x-auth-token']) )){
			$this->checkTypeQuery = 'get';
		}
	}

	public function canTryExecuteWPUmbrella(){

		if($this->checkTypeQuery === null){
			return false;
		}

		return true;

	}

	public function getAction(){
		switch($this->checkTypeQuery){
			case 'headers':
				return isset($this->headers['x-action']) ? $this->headers['x-action'] : null;
			case 'post':
				return isset($this->request['x-action']) ? $this->request['x-action'] : null;
			case 'get':
				return isset($this->query['x-action']) ? $this->query['x-action'] : null;
			default:
				return null;
		}
	}

	public function getRequestVersion(){
		switch($this->checkTypeQuery){
			case 'headers':
				return isset($this->headers['x-request-version']) ? $this->headers['x-request-version'] : 'v1';
			case 'post':
				return isset($this->request['x-request-version']) ? $this->request['x-request-version'] : 'v1';
			case 'get':
				return isset($this->query['x-request-version']) ? $this->query['x-request-version'] : 'v1';
			default:
				return 'v1';
		}
	}

	public function getParam($name){

		switch($this->checkTypeQuery){
			case 'headers':
				return isset($this->headers[$name]) ? $this->headers[$name] : null;
			case 'post':
				return isset($this->request[$name]) ? $this->request[$name] : null;
			case 'get':
				return isset($this->query[$name]) ? $this->query[$name] : null;
			default:
				return null;
		}
	}

	public function getSecretToken(){
		switch($this->checkTypeQuery){
			case 'headers':
				if(isset($this->headers['x-secret-token'])){
					return $this->headers['x-secret-token'];
				}
				if(isset($this->headers['x-auth-token'])){
					return $this->headers['x-auth-token'];
				}
				return null;

			case 'post':
				if(isset($this->request['x-secret-token'])){
					return $this->request['x-secret-token'];
				}
				if(isset($this->request['x-auth-token'])){
					return $this->request['x-auth-token'];
				}
				return null;
			case 'get':
				if(isset($this->query['x-secret-token'])){
					return $this->query['x-secret-token'];
				}
				if(isset($this->query['x-auth-token'])){
					return $this->query['x-auth-token'];
				}
				return null;
			default:
				return null;
		}
	}

	public function getToken(){
		switch($this->checkTypeQuery){
			case 'headers':
				return $this->headers['x-umbrella'];
			case 'post':
				return $this->request['x-umbrella'];
			case 'get':
				return $this->query['x-umbrella'];
			default:
				return null;
		}
	}

}
