<?php

namespace WPUmbrella\Services;


class RequestSettings
{
	protected $updateCallResponse;
    protected $updateCallBody;


    public function buildRequestSettings($data = [])
    {

        $this->simulateAdminEnvironment($data);

        // Master should never get redirected by the worker, since it expects worker response.
        add_filter('wp_redirect', [$this, 'disableRedirect']);

		wp_umbrella_get_service('WordPressContext')->set('_wp_using_ext_object_cache', false);
    }

    protected function simulateAdminEnvironment($data)
    {
        $context = wp_umbrella_get_service('WordPressContext');

        $_SERVER['PHP_SELF']       = '/wp-admin/'.( isset($data['wp_page']) && !empty($data['wp_page']) ? $data['wp_page'] : 'index.php');
        $_COOKIE['redirect_count'] = '10'; // hack for the WordPress HTTPS plugin, so it doesn't redirect us

        if (defined('FORCE_SSL_ADMIN') && FORCE_SSL_ADMIN) {
            $_SERVER['HTTPS']       = 'on';
            $_SERVER['SERVER_PORT'] = '443';
        }

        $context->setConstant('WP_ADMIN', true);
        $context->setConstant('WP_USER_ADMIN', false);
        $context->setConstant('WP_BLOG_ADMIN', true);
    }


    public function adminLoaded()
    {
        $context = wp_umbrella_get_service('WordPressContext');

        add_filter('http_response', [$this, 'captureCacheUpdateCall'], WP_UMBRELLA_MAX_PRIORITY_HOOK, 3);
        add_filter('pre_http_request', [$this, 'interceptCacheUpdateCall'], WP_UMBRELLA_MAX_PRIORITY_HOOK, 3);
        require_once wp_umbrella_get_service('WordPressContext')->getConstant('ABSPATH').'wp-admin/includes/admin.php';

		// do_action('admin_init');
        global $wp_current_filter;
        $wp_current_filter[] = 'load-update-core.php';

        if (function_exists('wp_clean_update_cache') && apply_filters('wp_umbrella_clean_cache_on_request', false)) {
            wp_clean_update_cache();
        }

        if(function_exists('wp_update_plugins')){
			wp_update_plugins();
		}

        if(function_exists('wp_update_themes')){
			wp_update_themes();
		}

        array_pop($wp_current_filter);

        set_current_screen();
        do_action('load-update-core.php');

        if(function_exists('wp_version_check')){
			wp_version_check();
			wp_version_check(array(), true);
		}

    }

    /**
     * @internal
     */
    public function disableRedirect()
    {
        return false;
    }


    public function captureCacheUpdateCall($response, $args, $url)
    {
        if ($url !== 'https://api.wordpress.org/plugins/update-check/1.1/') {
            return $response;
        }

        $this->updateCallResponse = $response;
        $this->updateCallBody     = $args['body'];
        return $response;
    }

    public function interceptCacheUpdateCall($response, $args, $url)
    {
        if ($url !== 'https://api.wordpress.org/plugins/update-check/1.1/') {
            return $response;
        }
        if ($this->updateCallResponse === null) {
            return $response;
        }
        if ($this->updateCallBody !== http_build_query($args['body'])) {
            return $response;
        }
        return $this->updateCallResponse;
    }
}
