<?php
namespace WPUmbrella\Services\Restore\QueueRunner;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\Builder\RestoreBuilder;

class RestoreQueueRunnerFinish
{

	public function run()
    {

        $originator = wp_umbrella_get_service('RestoreConfiguration')->getOriginatorFromFile();
		$restorationId = $originator->getValueInState('restoration_id');
		$logfile = $originator->getValueInState('logfile');
		$logfile = sprintf('%s/%s/%s', WP_UMBRELLA_DIR_TEMP_RESTORE, 'logs', $logfile);

		wp_umbrella_get_service('RestorationApi')->postLog($restorationId, [
			"config" => $originator->getState(),
			"logs" => wp_umbrella_get_service('LogProcess')->getContent($logfile),
		]);

		wp_umbrella_get_service('RestoreRunner')->cleanup();
    }

}
