<?php
namespace WPUmbrella\Services\Restore\QueueRunner;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\Builder\RestoreBuilder;

class RestoreQueueRunnerPrepareFiles
{

	public function run()
    {
        $director = wp_umbrella_get_service('RestoreDirector');

        $builder = new RestoreBuilder();
        $director->setBuilder($builder);

		$director->buildPrepareRestoreFilesHandlers();
        $kernel = $builder->getKernel();

        $originator = wp_umbrella_get_service('RestoreConfiguration')->getOriginatorFromFile();

        $kernel->execute($originator);

    }

}
