<?php
namespace WPUmbrella\Services\Restore;

if (!defined('ABSPATH')) {
    exit;
}

class RestoreDirector
{
    public function setBuilder($builder)
    {
        $this->builder = $builder;
        return $this;
    }

    public function buildScanRestoration()
    {
        $this->builder->buildScanHandlers();
        $this->builder->buildCaretaker();
    }

	/**
	 * Scan download
	 */
    public function buildScanDownloadRestoration()
    {
        $this->builder->buildScanDownloadHandlers();
        $this->builder->buildCaretaker();
    }

	/**
	 * Scheduled donwload
	 */
    public function buildScheduledDownloadHandlers()
    {
        $this->builder->buildScheduledDownloadHandlers();
        $this->builder->buildCaretaker();
    }

	/**
	 * Download a zip
	 */
    public function buildDownloadRestoration()
    {
        $this->builder->buildDownloadHandlers();
        $this->builder->buildCaretaker();
    }

	/**
	 * Prepare files (config json by parts)
	 */
    public function buildPrepareRestoreFilesHandlers()
    {
        $this->builder->buildPrepareRestoreFilesHandlers();
        $this->builder->buildCaretaker();
    }

	/**
	 * Restore files
	 */
    public function buildRestoreFilesHandlers()
    {
        $this->builder->buildRestoreFilesHandlers();
        $this->builder->buildCaretaker();
    }

    public function buildRestoreDatabaseHandlers()
    {
        $this->builder->buildRestoreDatabaseHandlers();
        $this->builder->buildCaretaker();
    }

    public function buildExtractDatabaseHandlers()
    {
        $this->builder->buildExtractDatabaseHandlers();
        $this->builder->buildCaretaker();
    }
}
