<?php
namespace WPUmbrella\Services\Restore;

if (!defined('ABSPATH')) {
    exit;
}

use WPUmbrella\Core\Restore\Observers\MementoObserver;
use WPUmbrella\Core\Restore\Observers\LogStateObserver;
use WPUmbrella\Core\Restore\Observers\RestoreOnErrorObserver;

class RestoreProcessOrder
{
    /**
     * Scan can restore the database and files.
     *
     * @return array
     */
    public function getHandlersScanRestore()
    {
        return [
			[
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\InitProcessHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\MemoryLimitHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                ]
            ],
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\FilesystemPermissions::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ];
    }

    /**
     * Scan can download zip
     *
     * @return array
     */
    public function getHandlersScanDownloadRestore()
    {
        return [

            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\DiskSpaceHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ];
    }

    /**
     * Prepare can restore the files.
     *
     * @return array
     */
    public function getHandlersPrepareDataFiles()
    {
        return [
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\SetupShutdown::class,
            ],

            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\WordPressDataFilesHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ];
    }

    /**
     * Prepare can restore the database.
     *
     * @return array
     */
    public function getHandlersPrepareDataSql()
    {
        return [

            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\WordPressDataSqlHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ];
    }

	/**
	 * Handlers to download the zip for the files or for the database
	 */
    public function getHandlersScheduledDownloadZips()
    {
        return [
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\ScheduledDownloadZip::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ];
    }

	/**
	 * Handlers to download the zip for the files or for the database
	 */
    public function getHandlersDownloadZips()
    {
        return [

            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\CleanUpDownloadHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\DownloadBuildZipHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ];
    }


    public function getHandlersPrepareExtractZipFiles()
    {
        $init = $this->getHandlersPrepareDataFiles();

        return array_merge($init, [
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\CreatePartsRestoreFilesHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ]);
    }
    public function getHandlersExtractZipFiles()
    {
        $init = $this->getHandlersPrepareDataFiles();

        return array_merge($init, [
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\RestoreFilesHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ]);
    }

    public function getHandlersExtractZipDatabase()
    {
        $init = $this->getHandlersPrepareDataSql();

        return array_merge($init, [
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\ExtractDatabaseHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ]);
    }

    public function getHandlersRestoreDatabase()
    {
        return array_merge([

            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\WordPressLoadDataSqlHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
            [
                'handler' => \WPUmbrella\Core\Restore\ChainResponsibility\RestoreDatabaseHandler::class,
                'observers' => [
                    MementoObserver::class,
                    LogStateObserver::class,
                    RestoreOnErrorObserver::class,
                ]
            ],
        ]);
    }
}
