<?php
namespace WPUmbrella\Services;


class Snapshot
{
	public function getData(){
		$plugins = wp_umbrella_get_service('PluginsProvider')->getPlugins();
		$wordpressData = wp_umbrella_get_service('WordPressProvider')->get();
		$themes = wp_umbrella_get_service('ThemesProvider')->getThemes();

		return [
			'plugins' => $plugins,
			'warnings' => $wordpressData,
			'themes' => $themes
		];
	}

    public function handle()
    {
		if (function_exists('wp_clean_update_cache')) {
			wp_clean_update_cache();
		}

		if(function_exists('wp_update_plugins')){
			wp_update_plugins();
		}

		if(function_exists('wp_update_themes')){
			wp_update_themes();
		}

		if(function_exists('wp_version_check')){
			wp_version_check();
			wp_version_check(array(), true);
		}


		$data = $this->getData();

		wp_umbrella_get_service('Projects')->snapshotData($data);
    }

}
