<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:html="http://www.w3.org/TR/REC-html40" xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
    <xsl:template match="/">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <title>Google XML Sitemaps Generator</title>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
                <meta name="robots" content="index,follow"/>
                <style type="text/css">
                    body { font-family: 'Lucida Grande', 'Lucida Sans Unicode', Tahoma, Verdana, Arial, sans-serif; font-size: 12px; }
                    a { text-decoration: none; color: #4a4adc; }
                    table { margin-bottom: 20px; font-size:12px; }
                    table tr:nth-child(odd) { background-color: #F5F5F5; }
                    table tr th { min-width: 80px; padding: 5px 7px; text-align: left; }
                    table tr td { padding: 5px 7px; }
                    table tr td a { color: #4a4adc; }
                    .header { padding: 0; margin: 10px 0 20px; }
                </style>
            </head>
            <body>
                <xsl:apply-templates></xsl:apply-templates>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="sitemap:urlset">
        <h1>Sitemap</h1>
        <div class="header">
            <p>XML Sitemap is generated by <a href="https://wordpress.org/plugins/xml-sitemap-generator-for-google/">Google XML Sitemaps Generator Plugin</a><br/>
                You can get more information on Plugin page.</p>
        </div>
        <table cellspacing="0">
            <tr>
                <th>Page URL</th>
                <th>Priority</th>
                <th>Frequency</th>
                <th>Last Modified</th>
            </tr>
            <xsl:variable name="lower" select="'abcdefghijklmnopqrstuvwxyz'"/>
            <xsl:variable name="upper" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>
            <xsl:for-each select="./sitemap:url">
                <tr>
                    <xsl:if test="position() mod 2 != 1">
                        <xsl:attribute  name="class">high</xsl:attribute>
                    </xsl:if>
                    <td>
                        <xsl:variable name="page">
                            <xsl:value-of select="sitemap:loc"/>
                        </xsl:variable>
                        <a target="_blank" href="{$page}">
                            <xsl:value-of select="sitemap:loc"/>
                        </a>
                    </td>
                    <td>
                        <xsl:value-of select="sitemap:priority"/>
                    </td>
                    <td>
                        <xsl:value-of select="sitemap:changefreq"/>
                    </td>
                    <td>
                        <xsl:value-of select="sitemap:lastmod"/>
                    </td>
                </tr>
            </xsl:for-each>
        </table>
        <div class="footer">Generated by <a href="https://wpgrim.net/">WP Grim</a> -
            <a href="https://wordpress.org/plugins/xml-sitemap-generator-for-google/">Google XML Sitemaps Generator Plugin</a>
        </div>
    </xsl:template>
</xsl:stylesheet>